/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.chameleon.sharedprefs.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.ow2.chameleon.sharedprefs.SharedPreferences;
import org.ow2.chameleon.sharedprefs.xml.SharedPreferencesServiceImpl;
import org.ow2.chameleon.sharedprefs.xml.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedPreferencesImpl
implements SharedPreferences {
    private Logger m_logger = LoggerFactory.getLogger(SharedPreferencesServiceImpl.class);
    private final File m_file;
    private final File m_backupFile;
    private Map<String, Object> m_map;
    private final Object m_content = new Object();
    private WeakHashMap<SharedPreferences.OnSharedPreferenceChangeListener, Object> m_listeners;
    private long m_timestamp;

    SharedPreferencesImpl(File file, Map<String, Object> initialContents) {
        this.m_file = file;
        this.m_backupFile = SharedPreferencesImpl.makeBackupFile(file);
        this.m_map = initialContents != null ? initialContents : new HashMap();
        this.m_listeners = new WeakHashMap();
        this.m_timestamp = file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(Map<String, Object> newContents) {
        if (newContents != null) {
            SharedPreferencesImpl sharedPreferencesImpl = this;
            synchronized (sharedPreferencesImpl) {
                this.m_map = newContents;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.m_listeners.put(listener, this.m_content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            this.m_listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, ?> getAll() {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            return new HashMap<String, Object>(this.m_map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key, String defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            String v = (String)this.m_map.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key, int defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            Integer v = (Integer)this.m_map.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(String key, long defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            Long v = (Long)this.m_map.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(String key, float defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            Float v = (Float)this.m_map.get(key);
            return v != null ? v.floatValue() : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key, boolean defValue) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            Boolean v = (Boolean)this.m_map.get(key);
            return v != null ? v : defValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        SharedPreferencesImpl sharedPreferencesImpl = this;
        synchronized (sharedPreferencesImpl) {
            return this.m_map.containsKey(key);
        }
    }

    public SharedPreferences.Editor edit() {
        return new EditorImpl();
    }

    private FileOutputStream createFileOutputStream(File file) {
        FileOutputStream str = null;
        try {
            str = new FileOutputStream(file);
        }
        catch (FileNotFoundException e) {
            File parent = file.getParentFile();
            if (!parent.mkdir()) {
                this.m_logger.error("Couldn't create directory for SharedPreferences file " + file);
                return null;
            }
            try {
                str = new FileOutputStream(file);
            }
            catch (FileNotFoundException e2) {
                this.m_logger.error("Couldn't create SharedPreferences file " + file, (Throwable)e2);
            }
        }
        return str;
    }

    private boolean writeFileLocked() {
        if (this.m_file.exists()) {
            if (!this.m_backupFile.exists()) {
                if (!this.m_file.renameTo(this.m_backupFile)) {
                    this.m_logger.error("Couldn't rename file " + this.m_file + " to backup file " + this.m_backupFile);
                    return false;
                }
            } else {
                this.m_file.delete();
            }
        }
        try {
            FileOutputStream str = this.createFileOutputStream(this.m_file);
            if (str == null) {
                return false;
            }
            XMLUtils.writeMapXml(this.m_map, str);
            str.close();
            this.m_timestamp = this.m_file.lastModified();
            this.m_backupFile.delete();
            return true;
        }
        catch (XmlPullParserException e) {
            this.m_logger.warn("writeFileLocked: Got exception:", (Throwable)e);
        }
        catch (IOException e) {
            this.m_logger.warn("writeFileLocked: Got exception:", (Throwable)e);
        }
        if (this.m_file.exists() && !this.m_file.delete()) {
            this.m_logger.error("Couldn't clean up partially-written file " + this.m_file);
        }
        return false;
    }

    public static File makeBackupFile(File prefsFile) {
        return new File(prefsFile.getPath() + ".bak");
    }

    public boolean hasFileChanged() {
        return this.m_timestamp != this.m_file.lastModified();
    }

    public final class EditorImpl
    implements SharedPreferences.Editor {
        private final Map<String, Object> m_modified = new HashMap<String, Object>();
        private boolean m_clear = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putString(String key, String value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.m_modified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putInt(String key, int value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.m_modified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putLong(String key, long value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.m_modified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putFloat(String key, float value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.m_modified.put(key, Float.valueOf(value));
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.m_modified.put(key, value);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor remove(String key) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.m_modified.put(key, this);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SharedPreferences.Editor clear() {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.m_clear = true;
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean commit() {
            boolean returnValue;
            boolean hasListeners;
            ArrayList<String> keysModified = null;
            HashSet listeners = null;
            SharedPreferencesImpl sharedPreferencesImpl = SharedPreferencesImpl.this;
            synchronized (sharedPreferencesImpl) {
                boolean bl = hasListeners = SharedPreferencesImpl.this.m_listeners.size() > 0;
                if (hasListeners) {
                    keysModified = new ArrayList<String>();
                    listeners = new HashSet(SharedPreferencesImpl.this.m_listeners.keySet());
                }
                EditorImpl editorImpl = this;
                synchronized (editorImpl) {
                    if (this.m_clear) {
                        SharedPreferencesImpl.this.m_map.clear();
                        this.m_clear = false;
                    }
                    for (Map.Entry<String, Object> e : this.m_modified.entrySet()) {
                        String k = e.getKey();
                        Object v = e.getValue();
                        if (v == this) {
                            SharedPreferencesImpl.this.m_map.remove(k);
                        } else {
                            SharedPreferencesImpl.this.m_map.put(k, v);
                        }
                        if (!hasListeners) continue;
                        keysModified.add(k);
                    }
                    this.m_modified.clear();
                }
                returnValue = SharedPreferencesImpl.this.writeFileLocked();
            }
            if (hasListeners) {
                for (int i = keysModified.size() - 1; i >= 0; --i) {
                    String key = (String)keysModified.get(i);
                    for (SharedPreferences.OnSharedPreferenceChangeListener listener : listeners) {
                        if (listener == null) continue;
                        listener.onSharedPreferenceChanged((SharedPreferences)SharedPreferencesImpl.this, key);
                    }
                }
            }
            return returnValue;
        }
    }
}

