/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.chameria.webview;

import com.trolltech.qt.core.QUrl;
import com.trolltech.qt.core.Qt;
import com.trolltech.qt.network.QNetworkReply;
import com.trolltech.qt.webkit.QWebPage;
import com.trolltech.qt.webkit.QWebView;
import de.akquinet.chameria.webview.WebViewFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChameriaWebView
extends QWebView {
    private Logger m_logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Logger m_javascriptLogger = LoggerFactory.getLogger((String)"chameria.javascript");
    private WebViewFactory m_factory;

    public ChameriaWebView(WebViewFactory factory) {
        this.m_factory = factory;
        this.loadStarted.connect((Object)this, "loadStarted()");
        this.loadProgress.connect((Object)this, "loadProgress(int)");
        this.loadFinished.connect((Object)this, "loadDone()");
        this.linkClicked.connect((Object)this, "linkClicked(QUrl)");
        this.setPage(new QWebPage(){

            protected void javaScriptConsoleMessage(String message, int lineNumber, String sourceID) {
                ChameriaWebView.this.m_javascriptLogger.info("Javascript> " + message + " (" + sourceID + ", " + lineNumber + ")");
            }
        });
        this.page().setForwardUnsupportedContent(true);
        this.page().unsupportedContent.connect((Object)this, "save(QNetworkReply)");
        this.page().printRequested.connect((Object)this, "print()");
        this.page().windowCloseRequested.connect((Object)this, "windowCloseRequested()");
        this.page().mainFrame().setScrollBarPolicy(Qt.Orientation.Horizontal, this.m_factory.getHorizontalScrollBarQTPolicy());
        this.page().mainFrame().setScrollBarPolicy(Qt.Orientation.Vertical, this.m_factory.getVerticalScrollBarQTPolicy());
        if (!this.m_factory.isContextMenuSupported()) {
            this.setContextMenuPolicy(Qt.ContextMenuPolicy.NoContextMenu);
        }
    }

    protected QWebView createWindow(QWebPage.WebWindowType type) {
        this.m_logger.info("Open a new window");
        return this.m_factory.openWindow();
    }

    public void linkClicked(QUrl url) {
        this.m_logger.info("Link " + url);
    }

    public void loadStarted() {
        this.m_logger.info("Starting to load " + this.url());
    }

    public void loadDone() {
        this.m_logger.info("Loading done... " + this.url());
        this.repaint();
    }

    public void windowCloseRequested() {
        this.m_logger.info("Close the window");
        this.close();
    }

    public void print() {
        this.m_logger.info("Print Requested");
        this.m_factory.print(this);
    }

    public void loadProgress(int x) {
        if (x >= 10 && x % 10 == 0) {
            this.m_logger.info("Loading: " + x + " %");
        }
    }

    public void save(QNetworkReply reply) {
        this.m_logger.info("Unsupported Content : " + reply.url().toString() + " - Download request");
        this.m_factory.save(reply);
    }
}

