/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.configuration.impl;

import de.akquinet.jbosscc.guttenbase.configuration.DatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public abstract class AbstractDatabaseConfiguration
implements DatabaseConfiguration {
    private static final Logger LOG = Logger.getLogger(DatabaseConfiguration.class);
    protected final ConnectorRepository _connectorRepository;

    public AbstractDatabaseConfiguration(ConnectorRepository connectorRepository) {
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
    }

    protected void executeSQL(Connection connection, String sql) throws SQLException {
        LOG.debug((Object)("Executing: " + sql));
        Statement statement = connection.createStatement();
        statement.execute(sql);
        statement.close();
    }

    @Override
    public void beforeTableCopy(Connection connection, String connectorId, TableMetaData table) throws SQLException {
    }

    @Override
    public void afterTableCopy(Connection connection, String connectorId, TableMetaData table) throws SQLException {
    }
}

