/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.configuration.impl;

import de.akquinet.jbosscc.guttenbase.configuration.impl.DefaultTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import java.sql.Connection;
import java.sql.SQLException;

public class HsqldbTargetDatabaseConfiguration
extends DefaultTargetDatabaseConfiguration {
    public HsqldbTargetDatabaseConfiguration(ConnectorRepository connectorRepository) {
        super(connectorRepository);
    }

    @Override
    public void initializeTargetConnection(Connection connection, String connectorId) throws SQLException {
        connection.setAutoCommit(false);
        this.setReferentialIntegrity(connection, false, this._connectorRepository.getDatabaseMetaData(connectorId));
    }

    @Override
    public void finalizeTargetConnection(Connection connection, String connectorId) throws SQLException {
        this.setReferentialIntegrity(connection, true, this._connectorRepository.getDatabaseMetaData(connectorId));
    }

    private void setReferentialIntegrity(Connection connection, boolean enable, DatabaseMetaData databaseMetaData) throws SQLException {
        int databaseMajorVersion = databaseMetaData.getMajorVersion();
        String referentialIntegrity = enable ? "TRUE" : "FALSE";
        String command = databaseMajorVersion < 2 ? "SET REFERENTIAL_INTEGRITY " : "SET DATABASE REFERENTIAL INTEGRITY ";
        this.executeSQL(connection, command + referentialIntegrity);
    }
}

