/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.configuration.impl;

import de.akquinet.jbosscc.guttenbase.configuration.impl.DefaultTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.mapping.TableNameMapper;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class MsSqlTargetDatabaseConfiguration
extends DefaultTargetDatabaseConfiguration {
    public MsSqlTargetDatabaseConfiguration(ConnectorRepository connectorRepository) {
        super(connectorRepository);
    }

    @Override
    public void initializeTargetConnection(Connection connection, String connectorId) throws SQLException {
        connection.setAutoCommit(false);
        this.disableTableForeignKeys(connection, connectorId, this.getTableMetaData(connectorId));
    }

    @Override
    public void finalizeTargetConnection(Connection connection, String connectorId) throws SQLException {
        this.enableTableForeignKeys(connection, connectorId, this.getTableMetaData(connectorId));
    }

    @Override
    public void beforeInsert(Connection connection, String connectorId, TableMetaData table) throws SQLException {
        this.setIdentityInsert(connection, connectorId, true, table);
    }

    @Override
    public void afterInsert(Connection connection, String connectorId, TableMetaData table) throws SQLException {
        this.setIdentityInsert(connection, connectorId, false, table);
    }

    private List<TableMetaData> getTableMetaData(String connectorId) throws SQLException {
        return this._connectorRepository.getDatabaseMetaData(connectorId).getTableMetaData();
    }

    private void disableTableForeignKeys(Connection connection, String connectorId, List<TableMetaData> tableMetaData) throws SQLException {
        this.setTableForeignKeys(connection, connectorId, tableMetaData, false);
    }

    private void enableTableForeignKeys(Connection connection, String connectorId, List<TableMetaData> tableMetaData) throws SQLException {
        this.setTableForeignKeys(connection, connectorId, tableMetaData, true);
    }

    private void setTableForeignKeys(Connection connection, String connectorId, List<TableMetaData> tableMetaDatas, boolean enable) throws SQLException {
        TableNameMapper tableNameMapper = this._connectorRepository.getConnectorHint(connectorId, TableNameMapper.class).getValue();
        for (TableMetaData tableMetaData : tableMetaDatas) {
            String tableName = tableNameMapper.mapTableName(tableMetaData);
            this.executeSQL(connection, "ALTER TABLE " + tableName + (enable ? " CHECK CONSTRAINT ALL" : " NOCHECK CONSTRAINT ALL"));
        }
    }

    private void setIdentityInsert(Connection connection, String connectorId, boolean enable, TableMetaData tableMetaData) throws SQLException {
        TableNameMapper tableNameMapper = this._connectorRepository.getConnectorHint(connectorId, TableNameMapper.class).getValue();
        String tableName = tableNameMapper.mapTableName(tableMetaData);
        if (this.hasIdentityColumn(tableMetaData)) {
            this.executeSQL(connection, "SET IDENTITY_INSERT " + tableName + " " + (enable ? "ON" : "OFF"));
        }
    }

    private boolean hasIdentityColumn(TableMetaData tableMetaData) {
        for (ColumnMetaData columnMetaData : tableMetaData.getColumnMetaData()) {
            if (!columnMetaData.getColumnTypeName().contains("IDENTITY")) continue;
            return true;
        }
        return false;
    }
}

