/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.configuration.impl;

import de.akquinet.jbosscc.guttenbase.configuration.impl.DefaultTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import java.sql.Connection;
import java.sql.SQLException;

public class MySqlTargetDatabaseConfiguration
extends DefaultTargetDatabaseConfiguration {
    public MySqlTargetDatabaseConfiguration(ConnectorRepository connectorRepository) {
        super(connectorRepository);
    }

    @Override
    public void initializeTargetConnection(Connection connection, String connectorId) throws SQLException {
        connection.setAutoCommit(false);
        this.setReferentialIntegrity(connection, false);
    }

    @Override
    public void finalizeTargetConnection(Connection connection, String connectorId) throws SQLException {
        this.setReferentialIntegrity(connection, true);
    }

    private void setReferentialIntegrity(Connection connection, boolean enable) throws SQLException {
        this.executeSQL(connection, "SET FOREIGN_KEY_CHECKS = " + (enable ? "1" : "0") + ";");
    }
}

