/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.configuration.impl;

import de.akquinet.jbosscc.guttenbase.configuration.impl.DefaultTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.hints.TableOrderHint;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.tools.ScriptExecutorTool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class OracleTargetDatabaseConfiguration
extends DefaultTargetDatabaseConfiguration {
    public OracleTargetDatabaseConfiguration(ConnectorRepository connectorRepository) {
        super(connectorRepository);
    }

    @Override
    public void initializeTargetConnection(Connection connection, String connectorId) throws SQLException {
        connection.setAutoCommit(false);
        this.setReferentialIntegrity(connection, connectorId, this.getTableMetaData(connectorId), false);
    }

    @Override
    public void finalizeTargetConnection(Connection connection, String connectorId) throws SQLException {
        this.setReferentialIntegrity(connection, connectorId, this.getTableMetaData(connectorId), true);
    }

    private List<TableMetaData> getTableMetaData(String connectorId) throws SQLException {
        return TableOrderHint.getSortedTables(this._connectorRepository, connectorId);
    }

    private void setReferentialIntegrity(Connection connection, String connectorId, List<TableMetaData> tableMetaDatas, boolean enable) throws SQLException {
        String tablesList = this.createTablesList(tableMetaDatas);
        if (!"".equals(tablesList)) {
            List<Map<String, Object>> foreignKeyNames = new ScriptExecutorTool(this._connectorRepository).executeQuery(connectorId, "SELECT TABLE_NAME, CONSTRAINT_NAME FROM USER_CONSTRAINTS WHERE CONSTRAINT_TYPE = 'R' AND TABLE_NAME IN (" + tablesList + ")");
            for (Map<String, Object> fkMap : foreignKeyNames) {
                String tableName = fkMap.get("TABLE_NAME").toString();
                String constraintName = fkMap.get("CONSTRAINT_NAME").toString();
                this.executeSQL(connection, "ALTER TABLE " + tableName + (enable ? " ENABLE " : " DISABLE ") + "CONSTRAINT " + constraintName);
            }
        }
    }

    private String createTablesList(List<TableMetaData> tableMetaDatas) {
        StringBuilder tablesBuilder = new StringBuilder();
        for (TableMetaData tableMetaData : tableMetaDatas) {
            tablesBuilder.append("'" + tableMetaData.getTableName() + "'" + ", ");
        }
        if (tablesBuilder.length() > 2) {
            tablesBuilder.setLength(tablesBuilder.length() - 2);
        }
        return tablesBuilder.toString();
    }
}

