/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.configuration.impl;

import de.akquinet.jbosscc.guttenbase.configuration.impl.DefaultTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.hints.TableOrderHint;
import de.akquinet.jbosscc.guttenbase.mapping.TableNameMapper;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.tools.postgresql.PostgresqlVacuumTablesTool;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public class PostgresqlTargetDatabaseConfiguration
extends DefaultTargetDatabaseConfiguration {
    private final boolean _vacuumAfterCopy;

    public PostgresqlTargetDatabaseConfiguration(ConnectorRepository connectorRepository) {
        this(connectorRepository, true);
    }

    public PostgresqlTargetDatabaseConfiguration(ConnectorRepository connectorRepository, boolean vacuumAfterCopy) {
        super(connectorRepository);
        this._vacuumAfterCopy = vacuumAfterCopy;
    }

    @Override
    public void afterTableCopy(Connection connection, String connectorId, TableMetaData table) throws SQLException {
        if (this._vacuumAfterCopy) {
            new PostgresqlVacuumTablesTool(this._connectorRepository).executeOnTable(connectorId, false, false, table);
        }
    }

    @Override
    public void initializeTargetConnection(Connection connection, String connectorId) throws SQLException {
        connection.setAutoCommit(false);
        this.setReferentialIntegrity(connection, connectorId, this.getTableMetaData(connectorId), false);
    }

    @Override
    public void finalizeTargetConnection(Connection connection, String connectorId) throws SQLException {
        this.setReferentialIntegrity(connection, connectorId, this.getTableMetaData(connectorId), true);
    }

    private List<TableMetaData> getTableMetaData(String connectorId) throws SQLException {
        return TableOrderHint.getSortedTables(this._connectorRepository, connectorId);
    }

    private void setReferentialIntegrity(Connection connection, String connectorId, List<TableMetaData> tableMetaDatas, boolean enable) throws SQLException {
        for (TableMetaData tableMetaData : tableMetaDatas) {
            TableNameMapper tableNameMapper = this._connectorRepository.getConnectorHint(connectorId, TableNameMapper.class).getValue();
            String tableName = tableNameMapper.mapTableName(tableMetaData);
            this.executeSQL(connection, "ALTER TABLE " + tableName + (enable ? " ENABLE " : " DISABLE ") + "TRIGGER ALL;");
        }
    }
}

