/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.connector.impl;

import de.akquinet.jbosscc.guttenbase.configuration.SourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.connector.Connector;
import de.akquinet.jbosscc.guttenbase.connector.ConnectorInfo;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.repository.impl.DatabaseMetaDataInspectorTool;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class AbstractConnector
implements Connector {
    protected static final Logger LOG = Logger.getLogger(AbstractConnector.class);
    protected transient Connection _connection;
    protected final ConnectorRepository _connectorRepository;
    protected final String _connectorId;
    protected final ConnectorInfo _connectionInfo;

    public AbstractConnector(ConnectorRepository connectorRepository, String connectorId, ConnectorInfo connectionInfo) {
        assert (connectionInfo != null) : "connectionInfo != null";
        assert (connectorId != null) : "connectorId != null";
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectionInfo = connectionInfo;
        this._connectorRepository = connectorRepository;
        this._connectorId = connectorId;
    }

    @Override
    public void closeConnection() throws SQLException {
        try {
            if (this._connection != null && !this._connection.isClosed()) {
                if (!this._connection.getAutoCommit()) {
                    this._connection.commit();
                }
                this._connection.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Closing connection failed", (Throwable)e);
            throw e;
        }
        finally {
            this._connection = null;
        }
    }

    @Override
    public DatabaseMetaData retrieveDatabaseMetaData() throws SQLException {
        DatabaseMetaDataInspectorTool tableMetaDataInspector = new DatabaseMetaDataInspectorTool(this._connectorRepository, this._connectorId);
        Connection connection = this.openConnection();
        SourceDatabaseConfiguration sourceDatabaseConfiguration = this._connectorRepository.getSourceDatabaseConfiguration(this._connectorId);
        sourceDatabaseConfiguration.initializeSourceConnection(connection, this._connectorId);
        DatabaseMetaData databaseMetaData = tableMetaDataInspector.getDatabaseMetaData(connection);
        sourceDatabaseConfiguration.finalizeSourceConnection(connection, this._connectorId);
        this.closeConnection();
        return databaseMetaData;
    }
}

