/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.connector.impl;

import de.akquinet.jbosscc.guttenbase.connector.impl.AbstractConnector;
import de.akquinet.jbosscc.guttenbase.connector.impl.URLConnectorInfo;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public abstract class AbstractURLConnector
extends AbstractConnector {
    protected static final Logger LOG = Logger.getLogger(AbstractURLConnector.class);
    private final URLConnectorInfo _urlConnectionInfo;

    public AbstractURLConnector(ConnectorRepository connectorRepository, String connectorId, URLConnectorInfo urlConnectionInfo) {
        super(connectorRepository, connectorId, urlConnectionInfo);
        assert (urlConnectionInfo != null) : "urlConnectionInfo != null";
        this._urlConnectionInfo = urlConnectionInfo;
    }

    @Override
    public Connection openConnection() throws SQLException {
        if (this._connection == null || this._connection.isClosed()) {
            try {
                Class.forName(this._urlConnectionInfo.getDriver()).newInstance();
            }
            catch (Exception e) {
                LOG.error((Object)"JDBC driver not found", (Throwable)e);
                throw new SQLException("Creating JDBC driver", e);
            }
            this._connection = DriverManager.getConnection(this._urlConnectionInfo.getUrl(), this._urlConnectionInfo.getUser(), this._urlConnectionInfo.getPassword());
        }
        return this._connection;
    }
}

