/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.connector.impl;

import de.akquinet.jbosscc.guttenbase.connector.Connector;
import de.akquinet.jbosscc.guttenbase.connector.ConnectorInfo;
import de.akquinet.jbosscc.guttenbase.connector.DatabaseType;
import de.akquinet.jbosscc.guttenbase.connector.impl.DataSourceConnector;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import javax.sql.DataSource;

public class DataSourceConnectorInfo
implements ConnectorInfo {
    private static final long serialVersionUID = 1L;
    private final DataSource _dataSource;
    private final String _user;
    private final String _password;
    private final String _schema;
    private final DatabaseType _databaseType;

    public DataSourceConnectorInfo(DataSource dataSource, String user, String password, String schema, DatabaseType databaseType) {
        assert (schema != null) : "schema != null";
        assert (dataSource != null) : "dataSource != null";
        assert (databaseType != null) : "databaseType != null";
        this._dataSource = dataSource;
        this._user = user;
        this._password = password;
        this._schema = schema;
        this._databaseType = databaseType;
    }

    @Override
    public String getUser() {
        return this._user;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    @Override
    public String getSchema() {
        return this._schema;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this._databaseType;
    }

    @Override
    public Connector createConnector(ConnectorRepository connectorRepository, String connectorId) {
        return new DataSourceConnector(connectorRepository, connectorId, this);
    }
}

