/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class ExportDumpBlob
implements Externalizable,
Blob {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BUFFER_SIZE = 0xA00000;
    private transient File _tempFile;
    private final transient InputStream _inputStream;

    public ExportDumpBlob() {
        this(null);
    }

    public ExportDumpBlob(InputStream inputStream) {
        this._inputStream = inputStream;
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        byte[] buffer = new byte[0xA00000];
        int n = this._inputStream.read(buffer);
        while (n > 0) {
            byte[] buf = buffer;
            if (n < 0xA00000) {
                buf = new byte[n];
                System.arraycopy(buffer, 0, buf, 0, n);
            }
            output.writeObject(buf);
            output.flush();
            n = this._inputStream.read(buffer);
        }
        output.writeObject(null);
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        this._tempFile = File.createTempFile("GB-DUMP-", null);
        this._tempFile.deleteOnExit();
        FileOutputStream fileOutputStream = new FileOutputStream(this._tempFile);
        byte[] buffer = (byte[])input.readObject();
        while (buffer != null) {
            fileOutputStream.write(buffer, 0, buffer.length);
            buffer = (byte[])input.readObject();
        }
        fileOutputStream.close();
    }

    @Override
    public long length() throws SQLException {
        return this._tempFile.length();
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            InputStream inputStream = this.getBinaryStream(pos, length);
            byte[] bytes = new byte[length];
            inputStream.read(bytes);
            return bytes;
        }
        catch (IOException e) {
            throw new SQLException("getBytes", e);
        }
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(0L, this.length());
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        try {
            FileInputStream inputStream = new FileInputStream(this._tempFile);
            inputStream.skip(pos);
            return inputStream;
        }
        catch (IOException e) {
            throw new SQLException("getBinaryStream", e);
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void free() throws SQLException {
        this._tempFile.delete();
        this._tempFile = null;
    }
}

