/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export;

import de.akquinet.jbosscc.guttenbase.exceptions.ExportException;
import de.akquinet.jbosscc.guttenbase.export.ExportDumpPreparedStatement;
import de.akquinet.jbosscc.guttenbase.export.ExportTableHeaderImpl;
import de.akquinet.jbosscc.guttenbase.export.Exporter;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ExportDumpConnection
implements Connection {
    private final Exporter _exporter;
    private boolean _closed;
    private final Set<TableMetaData> _exportedTables = new HashSet<TableMetaData>();
    private TableMetaData _currentTableMetaData;

    public ExportDumpConnection(Exporter exporter) {
        assert (exporter != null) : "exporter != null";
        this._exporter = exporter;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this._exportedTables.add(this._currentTableMetaData)) {
            this.writeTableHeader(this._currentTableMetaData);
        }
        return new ExportDumpPreparedStatement(this._exporter);
    }

    public void initializeWriteTableData(TableMetaData table) throws ExportException {
        assert (table != null) : "table != null";
        this._currentTableMetaData = table;
        try {
            this._exporter.initializeWriteTableData(table);
        }
        catch (Exception e) {
            throw new ExportException("initializeWriteTableData", e);
        }
    }

    public void finalizeWriteTableData(TableMetaData table) throws ExportException {
        this._currentTableMetaData = null;
        try {
            this._exporter.finalizeWriteTableData(table);
        }
        catch (Exception e) {
            throw new ExportException("finalizeWriteTableData", e);
        }
    }

    public void initializeWriteRowData(TableMetaData table) throws ExportException {
        try {
            this._exporter.initializeWriteRowData(table);
        }
        catch (Exception e) {
            throw new ExportException("initializeWriteRowData", e);
        }
    }

    public void finalizeWriteRowData(TableMetaData table) throws ExportException {
        try {
            this._exporter.finalizeWriteRowData(table);
        }
        catch (Exception e) {
            throw new ExportException("finalizeWriteRowData", e);
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this._exporter.finishExport();
        }
        catch (Exception e) {
            throw new ExportException("close", e);
        }
        finally {
            this._closed = true;
            this._exportedTables.clear();
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this._exporter.flush();
        }
        catch (Exception e) {
            throw new ExportException("commit", e);
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return this.prepareStatement(sql);
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.prepareStatement("");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCatalog() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    private void writeTableHeader(TableMetaData tableMetaData) throws SQLException {
        try {
            this._exporter.writeTableHeader(new ExportTableHeaderImpl(tableMetaData.getTableName()));
        }
        catch (Exception e) {
            throw new ExportException("writeTableHeader", e);
        }
    }
}

