/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export;

import de.akquinet.jbosscc.guttenbase.connector.impl.AbstractConnector;
import de.akquinet.jbosscc.guttenbase.exceptions.ExportException;
import de.akquinet.jbosscc.guttenbase.export.ExportDumpConnection;
import de.akquinet.jbosscc.guttenbase.export.ExportDumpConnectorInfo;
import de.akquinet.jbosscc.guttenbase.export.Exporter;
import de.akquinet.jbosscc.guttenbase.export.ExporterFactory;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.InternalTableMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.utils.Util;
import java.sql.Connection;
import java.sql.SQLException;

public class ExportDumpConnector
extends AbstractConnector {
    private final ExportDumpConnectorInfo _exportDumpConnectionInfo;

    public ExportDumpConnector(ConnectorRepository connectorRepository, String connectorId, ExportDumpConnectorInfo exportDumpConnectionInfo) {
        super(connectorRepository, connectorId, exportDumpConnectionInfo);
        this._exportDumpConnectionInfo = exportDumpConnectionInfo;
    }

    @Override
    public Connection openConnection() throws SQLException {
        if (this._connection == null || this._connection.isClosed()) {
            try {
                Exporter exporter = this._connectorRepository.getConnectorHint(this._connectorId, ExporterFactory.class).getValue().createExporter();
                exporter.initializeExport(this._connectorRepository, this._connectorId, this._exportDumpConnectionInfo);
                exporter.writeDatabaseMetaData(this.retrieveSourceDatabaseMetaData());
                this._connection = new ExportDumpConnection(exporter);
            }
            catch (Exception e) {
                throw new ExportException("openConnection", e);
            }
        }
        return this._connection;
    }

    @Override
    public DatabaseMetaData retrieveDatabaseMetaData() throws SQLException {
        DatabaseMetaData data = this.retrieveSourceDatabaseMetaData();
        DatabaseMetaData result = Util.copyObject(DatabaseMetaData.class, data);
        for (TableMetaData tableMetaData : result.getTableMetaData()) {
            ((InternalTableMetaData)tableMetaData).setRowCount(0);
        }
        return result;
    }

    private DatabaseMetaData retrieveSourceDatabaseMetaData() throws SQLException {
        return this._connectorRepository.getDatabaseMetaData(this._exportDumpConnectionInfo.getSourceConnectorId());
    }
}

