/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export;

import de.akquinet.jbosscc.guttenbase.connector.impl.AbstractConnector;
import de.akquinet.jbosscc.guttenbase.exceptions.ImportException;
import de.akquinet.jbosscc.guttenbase.export.ImportDumpConnection;
import de.akquinet.jbosscc.guttenbase.export.ImportDumpConnectionInfo;
import de.akquinet.jbosscc.guttenbase.export.Importer;
import de.akquinet.jbosscc.guttenbase.export.ImporterFactory;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import java.sql.Connection;
import java.sql.SQLException;

public class ImportDumpConnector
extends AbstractConnector {
    private final ImportDumpConnectionInfo _importDumpConnectionInfo;
    private DatabaseMetaData _databaseMetaData;

    public ImportDumpConnector(ConnectorRepository connectorRepository, String connectorId, ImportDumpConnectionInfo importDumpConnectionInfo) {
        super(connectorRepository, connectorId, importDumpConnectionInfo);
        this._importDumpConnectionInfo = importDumpConnectionInfo;
    }

    @Override
    public Connection openConnection() throws SQLException {
        if (this._connection == null || this._connection.isClosed()) {
            try {
                Importer importer = this._connectorRepository.getConnectorHint(this._connectorId, ImporterFactory.class).getValue().createImporter();
                importer.initializeImport(this._connectorRepository, this._connectorId, this._importDumpConnectionInfo);
                this._databaseMetaData = importer.readDatabaseMetaData();
                this._connection = new ImportDumpConnection(importer);
            }
            catch (Exception e) {
                throw new ImportException("openConnection", e);
            }
        }
        return this._connection;
    }

    @Override
    public DatabaseMetaData retrieveDatabaseMetaData() throws SQLException {
        this.openConnection();
        this.closeConnection();
        return this._databaseMetaData;
    }
}

