/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export.plain;

import de.akquinet.jbosscc.guttenbase.export.ExportDumpConnectorInfo;
import de.akquinet.jbosscc.guttenbase.export.ExportDumpExtraInformation;
import de.akquinet.jbosscc.guttenbase.export.ExportTableHeader;
import de.akquinet.jbosscc.guttenbase.export.Exporter;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class PlainGzipExporter
implements Exporter {
    private ObjectOutputStream _objectOutputStream;
    private ConnectorRepository _connectorRepository;
    private String _connectorId;
    private ExportDumpConnectorInfo _exportDumpConnectionInfo;

    @Override
    public void initializeExport(ConnectorRepository connectorRepository, String connectorId, ExportDumpConnectorInfo exportDumpConnectionInfo) throws Exception {
        assert (exportDumpConnectionInfo != null) : "exportDumpConnectionInfo != null";
        assert (connectorId != null) : "connectorId != null";
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
        this._connectorId = connectorId;
        this._exportDumpConnectionInfo = exportDumpConnectionInfo;
        this.openOutputStream(exportDumpConnectionInfo);
    }

    @Override
    public void finishExport() throws Exception {
        this.writeExtraInformation();
        this._objectOutputStream.close();
        this._objectOutputStream = null;
    }

    @Override
    public void writeTableHeader(ExportTableHeader exportTableHeader) throws IOException {
        this._objectOutputStream.writeObject(exportTableHeader);
    }

    @Override
    public void writeDatabaseMetaData(DatabaseMetaData databaseMetaData) throws IOException {
        this._objectOutputStream.writeObject(databaseMetaData);
    }

    @Override
    public void initializeWriteTableData(TableMetaData table) {
    }

    @Override
    public void finalizeWriteTableData(TableMetaData table) {
    }

    @Override
    public void initializeWriteRowData(TableMetaData table) {
    }

    @Override
    public void finalizeWriteRowData(TableMetaData table) {
    }

    @Override
    public void flush() throws IOException {
        this._objectOutputStream.reset();
        this._objectOutputStream.flush();
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this._objectOutputStream.writeObject(obj);
    }

    private void writeExtraInformation() throws SQLException, IOException {
        ExportDumpExtraInformation exportDumpExtraInformation = this._connectorRepository.getConnectorHint(this._connectorId, ExportDumpExtraInformation.class).getValue();
        Map<String, Serializable> extraInformation = exportDumpExtraInformation.getExtraInformation(this._connectorRepository, this._connectorId, this._exportDumpConnectionInfo);
        this.writeObject(extraInformation);
    }

    private void openOutputStream(ExportDumpConnectorInfo exportDumpConnectionInfo) throws IOException {
        File file = new File(exportDumpConnectionInfo.getPath());
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(fileOutputStream);
        this._objectOutputStream = new ObjectOutputStream(gzipOutputStream);
    }
}

