/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export.plain;

import de.akquinet.jbosscc.guttenbase.export.ExportTableHeader;
import de.akquinet.jbosscc.guttenbase.export.ImportDumpConnectionInfo;
import de.akquinet.jbosscc.guttenbase.export.ImportDumpExtraInformation;
import de.akquinet.jbosscc.guttenbase.export.Importer;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class PlainGzipImporter
implements Importer {
    private ObjectInputStream _objectInputStream;
    private ConnectorRepository _connectorRepository;
    private String _connectorId;
    private boolean _tableDataRead = false;

    @Override
    public void initializeImport(ConnectorRepository connectorRepository, String connectorId, ImportDumpConnectionInfo importDumpConnectionInfo) throws IOException {
        assert (importDumpConnectionInfo != null) : "importDumpConnectionInfo != null";
        assert (connectorId != null) : "connectorId != null";
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
        this._connectorId = connectorId;
        File file = new File(importDumpConnectionInfo.getPath());
        FileInputStream fileInputStream = new FileInputStream(file);
        GZIPInputStream gzipInputStream = new GZIPInputStream(fileInputStream);
        this._objectInputStream = new ObjectInputStream(gzipInputStream);
    }

    @Override
    public void finishImport() throws Exception {
        if (this._tableDataRead) {
            this.readExtraInformation();
        }
        this._objectInputStream.close();
        this._objectInputStream = null;
    }

    @Override
    public DatabaseMetaData readDatabaseMetaData() throws Exception {
        return (DatabaseMetaData)this._objectInputStream.readObject();
    }

    @Override
    public void seekTableHeader(TableMetaData tableMetaData) throws Exception {
        ExportTableHeader exportTableHeader;
        this._tableDataRead = true;
        do {
            exportTableHeader = this.seekNextTableHeader();
        } while (!tableMetaData.getTableName().equalsIgnoreCase(exportTableHeader.getTableName()));
    }

    @Override
    public Object readObject() throws Exception {
        return this._objectInputStream.readObject();
    }

    private ExportTableHeader seekNextTableHeader() throws Exception {
        Object value;
        while (!((value = this._objectInputStream.readObject()) instanceof ExportTableHeader)) {
        }
        return (ExportTableHeader)value;
    }

    private void readExtraInformation() throws Exception {
        ImportDumpExtraInformation importDumpExtraInformation = this._connectorRepository.getConnectorHint(this._connectorId, ImportDumpExtraInformation.class).getValue();
        Map extraInformation = (Map)this.readObject();
        importDumpExtraInformation.processExtraInformation(extraInformation);
    }
}

