/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export.zip;

import de.akquinet.jbosscc.guttenbase.utils.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;

public class ZipClassesFromClassResourceExporter {
    private static final Logger LOG = Logger.getLogger(ZipClassesFromClassResourceExporter.class);
    private final ZipOutputStream _zipOutputStream;
    private final Set<String> _entries = new HashSet<String>();

    public ZipClassesFromClassResourceExporter(ZipOutputStream zipOutputStream) {
        this._zipOutputStream = zipOutputStream;
    }

    public void copyClassesToZip(Class<?> startupClass) throws IOException {
        boolean jarFile;
        String pathToClass = '/' + startupClass.getName().replace('.', '/') + ".class";
        URL resource = startupClass.getResource(pathToClass);
        String path = resource.getPath();
        String protocol = resource.getProtocol();
        if ("file".equalsIgnoreCase(protocol)) {
            path = resource.getPath().substring(0, path.length() - pathToClass.length());
            jarFile = false;
        } else if ("jar".equalsIgnoreCase(protocol)) {
            path = resource.getPath().substring(0, path.length() - (pathToClass.length() + 1));
            jarFile = true;
            if (path.startsWith("file:")) {
                path = path.substring(5);
            }
        } else {
            throw new IOException("Cannot handle protocol " + protocol + " while reading classes");
        }
        path = URLDecoder.decode(path, "UTF-8");
        if (jarFile) {
            this.copyClassesFromJar(path);
        } else {
            this.copyClassesFromFilesystem(path);
        }
    }

    private void copyClassesFromFilesystem(String path) throws IOException {
        File dir = new File(path);
        this.addDirectoryToJar(dir, path);
    }

    private void addDirectoryToJar(File dir, String path) throws IOException {
        assert (path != null) : "path!= null";
        assert (dir != null) : "dir!= null";
        for (File file : dir.listFiles()) {
            this.addFileToJar(file, path);
        }
    }

    private void addFileToJar(File file, String path) throws IOException, FileNotFoundException {
        if (!file.isFile()) {
            this.addDirectoryToJar(file, path);
        } else {
            String name = file.getPath().substring(path.length() + 1);
            FileInputStream inputStream = new FileInputStream(file);
            this.addEntry(name, inputStream);
        }
    }

    private void copyClassesFromJar(String path) throws FileNotFoundException, IOException {
        ZipFile zipFile = new ZipFile(new File(path));
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            this.addEntry(zipEntry.getName(), inputStream);
        }
        zipFile.close();
    }

    private void addEntry(String name, InputStream inputStream) throws IOException {
        if (!this._entries.add(name.toUpperCase()) || name.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            LOG.warn((Object)("Duplicate entry ignored: " + name));
        } else {
            ZipEntry zipEntry = new ZipEntry(name);
            this._zipOutputStream.putNextEntry(zipEntry);
            Util.copy(inputStream, this._zipOutputStream);
            inputStream.close();
            this._zipOutputStream.closeEntry();
        }
    }
}

