/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export.zip;

import de.akquinet.jbosscc.guttenbase.export.zip.ZipAbstractMetaDataWriter;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.InternalColumnMetaData;
import java.io.IOException;

public class ZipColumnMetaDataWriter
extends ZipAbstractMetaDataWriter {
    public static final String COLUMN_NAME = "Name";
    public static final String COLUMN_ID = "Column-Id";
    public static final String COLUMN_CLASS_NAME = "Class-Name";
    public static final String COLUMN_TYPE_NAME = "Type-Name";
    public static final String COLUMN_TYPE = "JDBC-Type";
    public static final String COLUMN_PRECISION = "Precision";
    public static final String COLUMN_SCALE = "Scale";
    public static final String COLUMN_REFERENCES = "References";
    public static final String COLUMN_REFERENCED_BY_ID = "Referenced-By-Id";
    public static final String COLUMN_REFERENCED_BY = "Referenced-By";
    public static final String PRIMARY_KEY = "Primary-Key";
    public static final String NULLABLE = "Nullable";
    public static final String AUTO_INCREMENT = "Auto-Increment";

    public ZipColumnMetaDataWriter writeColumnMetaDataEntry(ColumnMetaData columnMetaData) throws IOException {
        this.setProperty(COLUMN_NAME, columnMetaData.getColumnName());
        this.setProperty(COLUMN_CLASS_NAME, columnMetaData.getColumnClassName());
        this.setProperty(COLUMN_TYPE_NAME, columnMetaData.getColumnTypeName());
        this.setProperty(COLUMN_TYPE, String.valueOf(columnMetaData.getColumnType()));
        this.setProperty(COLUMN_PRECISION, String.valueOf(columnMetaData.getPrecision()));
        this.setProperty(COLUMN_PRECISION, String.valueOf(columnMetaData.getPrecision()));
        this.setProperty(COLUMN_SCALE, String.valueOf(columnMetaData.getScale()));
        this.setProperty(PRIMARY_KEY, String.valueOf(columnMetaData.isPrimaryKey()));
        this.setProperty(NULLABLE, String.valueOf(columnMetaData.isNullable()));
        this.setProperty(AUTO_INCREMENT, String.valueOf(columnMetaData.isAutoIncrement()));
        this.setProperty(COLUMN_ID, String.valueOf(((InternalColumnMetaData)columnMetaData).getColumnId()));
        InternalColumnMetaData referencedColumn = (InternalColumnMetaData)columnMetaData.getReferencedColumn();
        if (referencedColumn != null) {
            this.setProperty(COLUMN_REFERENCES, String.valueOf(referencedColumn.getColumnId()));
        }
        int i = 1;
        for (InternalColumnMetaData internalColumnMetaData : columnMetaData.getReferencedByColumn()) {
            this.setProperty(COLUMN_REFERENCED_BY_ID + i, String.valueOf(internalColumnMetaData.getColumnId()));
            this.setProperty(COLUMN_REFERENCED_BY + i, internalColumnMetaData.getColumnName());
            ++i;
        }
        return this;
    }
}

