/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export.zip;

import de.akquinet.jbosscc.guttenbase.export.zip.ZipAbstractMetaDataWriter;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import java.io.IOException;

public class ZipDatabaseMetaDataWriter
extends ZipAbstractMetaDataWriter {
    public static final String DATABASE_NAME = "Database";
    public static final String DATABASE_TYPE = "Database-Type";
    public static final String DATABASE_MAJOR_VERSION = "Major-Version";
    public static final String DATABASE_MINOR_VERSION = "Minor-Version";
    public static final String DATABASE_SCHEMA = "Database-Schema";
    public static final String TABLE_NAME = "Table-Name";

    public ZipDatabaseMetaDataWriter writeDatabaseMetaDataEntry(DatabaseMetaData databaseMetaData) throws IOException {
        this.setProperty(DATABASE_SCHEMA, databaseMetaData.getSchema());
        this.setProperty(DATABASE_NAME, databaseMetaData.getDatabaseName());
        this.setProperty(DATABASE_MAJOR_VERSION, String.valueOf(databaseMetaData.getMajorVersion()));
        this.setProperty(DATABASE_MINOR_VERSION, String.valueOf(databaseMetaData.getMinorVersion()));
        this.setProperty(DATABASE_TYPE, databaseMetaData.getDatabaseType().name());
        int i = 1;
        for (TableMetaData tableMetaData : databaseMetaData.getTableMetaData()) {
            this.setProperty(TABLE_NAME + i, tableMetaData.getTableName());
            ++i;
        }
        return this;
    }
}

