/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export.zip;

import de.akquinet.jbosscc.guttenbase.export.ExportDumpConnectorInfo;
import de.akquinet.jbosscc.guttenbase.export.ExportDumpExtraInformation;
import de.akquinet.jbosscc.guttenbase.export.ExportTableHeader;
import de.akquinet.jbosscc.guttenbase.export.Exporter;
import de.akquinet.jbosscc.guttenbase.export.zip.ZipClassesFromClassResourceExporter;
import de.akquinet.jbosscc.guttenbase.export.zip.ZipColumnMetaDataWriter;
import de.akquinet.jbosscc.guttenbase.export.zip.ZipDatabaseMetaDataWriter;
import de.akquinet.jbosscc.guttenbase.export.zip.ZipExporterClassResources;
import de.akquinet.jbosscc.guttenbase.export.zip.ZipIndexMetaDataWriter;
import de.akquinet.jbosscc.guttenbase.export.zip.ZipTableMetaDataWriter;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.IndexMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.utils.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipExporter
implements Exporter {
    private ZipOutputStream _zipOutputStream;
    private ObjectOutputStream _objectOutputStream;
    private File _tempFile;
    private ConnectorRepository _connectorRepository;
    private String _connectorId;
    private ExportDumpConnectorInfo _exportDumpConnectionInfo;

    @Override
    public void initializeExport(ConnectorRepository connectorRepository, String connectorId, ExportDumpConnectorInfo exportDumpConnectionInfo) throws IOException {
        assert (exportDumpConnectionInfo != null) : "exportDumpConnectionInfo != null";
        assert (connectorId != null) : "connectorId != null";
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
        this._connectorId = connectorId;
        this._exportDumpConnectionInfo = exportDumpConnectionInfo;
        File file = new File(exportDumpConnectionInfo.getPath());
        FileOutputStream fos = new FileOutputStream(file);
        this._zipOutputStream = new ZipOutputStream(fos);
        ZipExporterClassResources zipExporterClassResources = connectorRepository.getConnectorHint(connectorId, ZipExporterClassResources.class).getValue();
        this.addClassesToJar(connectorRepository, connectorId, zipExporterClassResources);
        this.writeManifestEntry(zipExporterClassResources);
    }

    @Override
    public void finishExport() throws Exception {
        this.writeExtraInformation();
        this._zipOutputStream.close();
        this._zipOutputStream = null;
    }

    @Override
    public void writeDatabaseMetaData(DatabaseMetaData databaseMetaData) throws IOException {
        this.writeDatabaseEntry(databaseMetaData);
        for (TableMetaData tableMetaData : databaseMetaData.getTableMetaData()) {
            this.writeTableEntry(tableMetaData);
            this.writeColumnEntries(tableMetaData);
            this.writeIndexEntries(tableMetaData);
        }
    }

    @Override
    public void writeTableHeader(ExportTableHeader exportTableHeader) throws IOException {
    }

    @Override
    public void initializeWriteTableData(TableMetaData tableMetaData) throws IOException {
        this.newEntry("GuttenBase/" + tableMetaData.getTableName() + "/" + "DATA");
        this._tempFile = File.createTempFile("GB-JAR-", null);
        this._tempFile.deleteOnExit();
        this._objectOutputStream = new ObjectOutputStream(new FileOutputStream(this._tempFile));
    }

    @Override
    public void finalizeWriteTableData(TableMetaData table) throws IOException {
        this._objectOutputStream.close();
        FileInputStream fis = new FileInputStream(this._tempFile);
        Util.copy(fis, this._zipOutputStream);
        this.closeEntry();
        this._tempFile.delete();
        this._tempFile = null;
        this._objectOutputStream = null;
    }

    @Override
    public void initializeWriteRowData(TableMetaData table) {
    }

    @Override
    public void finalizeWriteRowData(TableMetaData table) {
    }

    @Override
    public void flush() throws IOException {
        if (this._objectOutputStream != null) {
            this._objectOutputStream.reset();
            this._objectOutputStream.flush();
        }
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        this._objectOutputStream.writeObject(obj);
    }

    private void writeIndexEntries(TableMetaData tableMetaData) throws IOException {
        String indexPath = "GuttenBase/" + tableMetaData.getTableName() + "/" + "INDEXES" + "/";
        for (IndexMetaData indexMetaData : tableMetaData.getIndexes()) {
            this.newEntry(indexPath + indexMetaData.getIndexName() + ".txt");
            new ZipIndexMetaDataWriter().writeIndexMetaDataEntry(indexMetaData).store("Index meta data", this._zipOutputStream);
            this.closeEntry();
        }
    }

    private void writeColumnEntries(TableMetaData tableMetaData) throws IOException {
        String columnPath = "GuttenBase/" + tableMetaData.getTableName() + "/" + "COLUMNS" + "/";
        for (ColumnMetaData columnMetaData : tableMetaData.getColumnMetaData()) {
            this.newEntry(columnPath + columnMetaData.getColumnName() + ".txt");
            new ZipColumnMetaDataWriter().writeColumnMetaDataEntry(columnMetaData).store("Column meta data", this._zipOutputStream);
            this.closeEntry();
        }
    }

    private void writeTableEntry(TableMetaData tableMetaData) throws IOException {
        this.newEntry("GuttenBase/" + tableMetaData.getTableName() + "/" + "TABLE-INFO.txt");
        new ZipTableMetaDataWriter().writeTableMetaDataEntry(tableMetaData).store("Table meta data", this._zipOutputStream);
        this.closeEntry();
    }

    private void writeDatabaseEntry(DatabaseMetaData databaseMetaData) throws IOException {
        this.newEntry("GuttenBase/DB-INFO.txt");
        new ZipDatabaseMetaDataWriter().writeDatabaseMetaDataEntry(databaseMetaData).store("Database meta data", this._zipOutputStream);
        this.closeEntry();
        this.newEntry("GuttenBase/METADATA");
        this._zipOutputStream.write(Util.toByteArray(databaseMetaData));
        this.closeEntry();
    }

    private void newEntry(String name) throws IOException {
        this._zipOutputStream.putNextEntry(new ZipEntry(name));
    }

    private void closeEntry() throws IOException {
        this._zipOutputStream.closeEntry();
    }

    private void addClassesToJar(ConnectorRepository connectorRepository, String connectorId, ZipExporterClassResources zipExporterClassResources) throws IOException {
        ZipClassesFromClassResourceExporter zipClassesFromClassResourceExporter = new ZipClassesFromClassResourceExporter(this._zipOutputStream);
        List<Class<?>> classResources = zipExporterClassResources.getClassResources();
        for (Class<?> clazz : classResources) {
            zipClassesFromClassResourceExporter.copyClassesToZip(clazz);
        }
    }

    private void writeManifestEntry(ZipExporterClassResources zipExporterClassResources) throws IOException {
        this.newEntry("META-INF/MANIFEST.MF");
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(bos);
        printStream.println("Manifest-Version: 1.0");
        printStream.println("Created-By: GuttenBase ZIP Exporter");
        printStream.println("Main-Class: " + zipExporterClassResources.getStartupClass().getName());
        printStream.close();
        this._zipOutputStream.write(bos.toByteArray());
        this.closeEntry();
    }

    private void writeExtraInformation() throws SQLException, IOException {
        ExportDumpExtraInformation exportDumpExtraInformation = this._connectorRepository.getConnectorHint(this._connectorId, ExportDumpExtraInformation.class).getValue();
        Map<String, Serializable> extraInformation = exportDumpExtraInformation.getExtraInformation(this._connectorRepository, this._connectorId, this._exportDumpConnectionInfo);
        for (Map.Entry<String, Serializable> entry : extraInformation.entrySet()) {
            this.newEntry("GuttenBase/EXTRA-INFO/" + entry.getKey());
            byte[] byteArray = Util.toByteArray(entry.getValue());
            this._zipOutputStream.write(byteArray);
            this.closeEntry();
        }
    }
}

