/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export.zip;

import de.akquinet.jbosscc.guttenbase.export.ImportDumpConnectionInfo;
import de.akquinet.jbosscc.guttenbase.export.ImportDumpExtraInformation;
import de.akquinet.jbosscc.guttenbase.export.Importer;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.utils.Util;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipImporter
implements Importer {
    private ZipFile _zipFile;
    private ObjectInputStream _objectInputStream;
    private ConnectorRepository _connectorRepository;
    private String _connectorId;

    @Override
    public void initializeImport(ConnectorRepository connectorRepository, String connectorId, ImportDumpConnectionInfo importDumpConnectionInfo) throws Exception {
        assert (importDumpConnectionInfo != null) : "importDumpConnectionInfo != null";
        assert (connectorId != null) : "connectorId != null";
        assert (connectorRepository != null) : "connectorRepository != null";
        File file = new File(importDumpConnectionInfo.getPath());
        this._connectorRepository = connectorRepository;
        this._connectorId = connectorId;
        this._zipFile = new ZipFile(file);
    }

    @Override
    public void finishImport() throws Exception {
        this.readExtraInformation();
        this._zipFile.close();
        this._zipFile = null;
    }

    @Override
    public DatabaseMetaData readDatabaseMetaData() throws Exception {
        ZipEntry zipEntry = this._zipFile.getEntry("GuttenBase/METADATA");
        assert (zipEntry != null) : "zipEntry != null";
        InputStream inputStream = this._zipFile.getInputStream(zipEntry);
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        DatabaseMetaData databaseMetaData = (DatabaseMetaData)objectInputStream.readObject();
        objectInputStream.close();
        return databaseMetaData;
    }

    @Override
    public Object readObject() throws Exception {
        return this._objectInputStream.readObject();
    }

    @Override
    public void seekTableHeader(TableMetaData tableMetaData) throws Exception {
        if (this._objectInputStream != null) {
            this._objectInputStream.close();
        }
        ZipEntry zipEntry = this._zipFile.getEntry("GuttenBase/" + tableMetaData.getTableName() + "/" + "DATA");
        assert (zipEntry != null) : "zipEntry != null";
        this._objectInputStream = new ObjectInputStream(this._zipFile.getInputStream(zipEntry));
    }

    private void readExtraInformation() throws Exception {
        ImportDumpExtraInformation importDumpExtraInformation = this._connectorRepository.getConnectorHint(this._connectorId, ImportDumpExtraInformation.class).getValue();
        HashMap<String, Serializable> extraInformation = new HashMap<String, Serializable>();
        String prefix = "GuttenBase/EXTRA-INFO/";
        Enumeration<? extends ZipEntry> entries = this._zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String name = zipEntry.getName();
            if (!name.startsWith("GuttenBase/EXTRA-INFO/")) continue;
            InputStream inputStream = this._zipFile.getInputStream(zipEntry);
            String key = name.substring("GuttenBase/EXTRA-INFO/".length());
            Serializable value = Util.fromInputStream(Serializable.class, inputStream);
            inputStream.close();
            extraInformation.put(key, value);
        }
        importDumpExtraInformation.processExtraInformation(extraInformation);
    }
}

