/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.export.zip;

import de.akquinet.jbosscc.guttenbase.export.zip.ZipColumnMetaDataWriter;
import de.akquinet.jbosscc.guttenbase.export.zip.ZipDatabaseMetaDataWriter;
import de.akquinet.jbosscc.guttenbase.export.zip.ZipExporter;
import de.akquinet.jbosscc.guttenbase.export.zip.ZipIndexMetaDataWriter;
import de.akquinet.jbosscc.guttenbase.export.zip.ZipTableMetaDataWriter;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.IndexMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class ZipStartup
extends JPanel {
    private static final long serialVersionUID = 1L;

    public ZipStartup() {
        super(new BorderLayout());
    }

    public void initGUI() throws Exception {
        this.add((Component)this.createButtonPanel(), "South");
        DefaultTreeModel treeModel = this.createTreeModel();
        this.add((Component)new JScrollPane(new JTree(treeModel)), "Center");
    }

    private DefaultTreeModel createTreeModel() throws Exception {
        DatabaseMetaData databaseMetaData = this.readDatabaseMetaData();
        DefaultMutableTreeNode rootNode = this.addRootNode(databaseMetaData);
        this.addTableNodes(databaseMetaData, rootNode);
        return new DefaultTreeModel(rootNode);
    }

    private DatabaseMetaData readDatabaseMetaData() throws IOException, ClassNotFoundException {
        InputStream inputStream = ZipExporter.class.getResourceAsStream("/GuttenBase/METADATA");
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        DatabaseMetaData databaseMetaData = (DatabaseMetaData)objectInputStream.readObject();
        objectInputStream.close();
        return databaseMetaData;
    }

    private DefaultMutableTreeNode addRootNode(DatabaseMetaData databaseMetaData) throws IOException {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("GuttenBase");
        Properties databaseMetaDataProperties = new ZipDatabaseMetaDataWriter().writeDatabaseMetaDataEntry(databaseMetaData).getProperties();
        this.addMetaDataProperties(databaseMetaDataProperties, rootNode, "Table-Name");
        return rootNode;
    }

    private void addTableNodes(DatabaseMetaData databaseMetaData, DefaultMutableTreeNode rootNode) throws IOException {
        List<TableMetaData> tableMetaDatas = databaseMetaData.getTableMetaData();
        for (TableMetaData tableMetaData : tableMetaDatas) {
            Properties tableMetaDataProperties = new ZipTableMetaDataWriter().writeTableMetaDataEntry(tableMetaData).getProperties();
            DefaultMutableTreeNode tableNode = new DefaultMutableTreeNode(tableMetaData.getTableName());
            this.addMetaDataProperties(tableMetaDataProperties, tableNode, "XX");
            rootNode.add(tableNode);
            this.addColumnNodes(tableMetaData, tableNode);
            this.addIndexNodes(tableMetaData, tableNode);
        }
    }

    private void addColumnNodes(TableMetaData tableMetaData, DefaultMutableTreeNode tableNode) throws IOException {
        for (ColumnMetaData columnMetaData : tableMetaData.getColumnMetaData()) {
            Properties columnMetaDataProperties = new ZipColumnMetaDataWriter().writeColumnMetaDataEntry(columnMetaData).getProperties();
            DefaultMutableTreeNode columnNode = new DefaultMutableTreeNode(columnMetaData.getColumnName());
            this.addMetaDataProperties(columnMetaDataProperties, columnNode, "XX");
            tableNode.add(columnNode);
        }
    }

    private void addIndexNodes(TableMetaData tableMetaData, DefaultMutableTreeNode tableNode) throws IOException {
        DefaultMutableTreeNode indexesNode = new DefaultMutableTreeNode("Indexes");
        tableNode.add(indexesNode);
        for (IndexMetaData indexMetaData : tableMetaData.getIndexes()) {
            Properties columnMetaDataProperties = new ZipIndexMetaDataWriter().writeIndexMetaDataEntry(indexMetaData).getProperties();
            DefaultMutableTreeNode indexNode = new DefaultMutableTreeNode(indexMetaData.getIndexName());
            this.addMetaDataProperties(columnMetaDataProperties, indexNode, "XX");
            indexesNode.add(indexNode);
        }
    }

    private void addMetaDataProperties(Properties metaDataProperties, DefaultMutableTreeNode rootNode, String excludedProperty) throws IOException {
        Enumeration<Object> keysEnum = metaDataProperties.keys();
        while (keysEnum.hasMoreElements()) {
            String key = keysEnum.nextElement().toString();
            String value = metaDataProperties.getProperty(key);
            if (key.startsWith(excludedProperty)) continue;
            rootNode.add(new DefaultMutableTreeNode(key + ": " + value));
        }
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        buttonPanel.add(close);
        return buttonPanel;
    }

    public static void main(String[] args) {
        try {
            JFrame frame = new JFrame("GuttenBase GUI");
            ZipStartup startup = new ZipStartup();
            frame.setContentPane(startup);
            startup.initGUI();
            Dimension size = new Dimension(1200, 800);
            frame.setMinimumSize(size);
            frame.setSize(size);
            frame.setDefaultCloseOperation(2);
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }
}

