/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.hints.impl;

import de.akquinet.jbosscc.guttenbase.mapping.ColumnDataMapper;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnDataMapperProvider;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.ColumnType;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DefaultColumnDataMapperProvider
implements ColumnDataMapperProvider {
    private final Map<String, ColumnDataMapper> _mappings = new HashMap<String, ColumnDataMapper>();

    @Override
    public ColumnDataMapper findMapping(ColumnMetaData sourceColumnMetaData, ColumnMetaData targetColumnMetaData, ColumnType sourceColumnType, ColumnType targetColumnType) throws SQLException {
        ColumnDataMapper columnDataMapper = this.findMapping(sourceColumnType, targetColumnType);
        if (columnDataMapper != null && columnDataMapper.isApplicable(sourceColumnMetaData, targetColumnMetaData)) {
            return columnDataMapper;
        }
        return null;
    }

    @Override
    public void addMapping(ColumnType sourceColumnType, ColumnType targetColumnType, ColumnDataMapper columnDataMapper) {
        this._mappings.put(this.createKey(sourceColumnType, targetColumnType), columnDataMapper);
    }

    @Override
    public void removeMapping(ColumnType sourceColumnType, ColumnType targetColumnType) {
        this._mappings.remove(this.createKey(sourceColumnType, targetColumnType));
    }

    private String createKey(ColumnType sourceColumnType, ColumnType targetColumnType) {
        return sourceColumnType.name() + ":" + targetColumnType.name();
    }

    private ColumnDataMapper findMapping(ColumnType sourceColumnType, ColumnType targetColumnType) {
        return this._mappings.get(this.createKey(sourceColumnType, targetColumnType));
    }
}

