/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.meta;

import de.akquinet.jbosscc.guttenbase.exceptions.UnhandledColumnTypeException;
import de.akquinet.jbosscc.guttenbase.utils.Util;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ColumnType {
    CLASS_UNKNOWN(Void.class),
    CLASS_STRING(String.class),
    CLASS_BIGDECIMAL(BigDecimal.class),
    CLASS_BLOB(Blob.class, Clob.class),
    CLASS_OBJECT(Object.class, Serializable.class, Util.ByteArrayClass),
    CLASS_DATE(Date.class),
    CLASS_TIMESTAMP(Timestamp.class),
    CLASS_TIME(Time.class),
    CLASS_INTEGER(Integer.class),
    CLASS_BOOLEAN(Boolean.class),
    CLASS_LONG(Long.class, BigInteger.class),
    CLASS_DOUBLE(Double.class),
    CLASS_FLOAT(Float.class),
    CLASS_SHORT(Short.class);

    private final List<Class<?>> _columnClasses;
    private static final Map<Class<?>, ColumnType> COLUMN_TYPES;

    private ColumnType(Class<?> ... columnClasses) {
        this._columnClasses = Arrays.asList(columnClasses);
    }

    public Object getValue(ResultSet resultSet, int columnIndex) throws SQLException {
        Object result = this.getValueFromResultset(resultSet, columnIndex);
        if (resultSet.wasNull()) {
            return null;
        }
        return result;
    }

    private Object getValueFromResultset(ResultSet resultSet, int columnIndex) throws SQLException, UnhandledColumnTypeException {
        switch (this) {
            case CLASS_STRING: {
                return resultSet.getString(columnIndex);
            }
            case CLASS_DOUBLE: {
                return resultSet.getDouble(columnIndex);
            }
            case CLASS_INTEGER: {
                return resultSet.getInt(columnIndex);
            }
            case CLASS_LONG: {
                return resultSet.getLong(columnIndex);
            }
            case CLASS_BLOB: {
                return resultSet.getBlob(columnIndex);
            }
            case CLASS_FLOAT: {
                return Float.valueOf(resultSet.getFloat(columnIndex));
            }
            case CLASS_BOOLEAN: {
                return resultSet.getBoolean(columnIndex);
            }
            case CLASS_BIGDECIMAL: {
                return resultSet.getBigDecimal(columnIndex);
            }
            case CLASS_TIMESTAMP: {
                return resultSet.getTimestamp(columnIndex);
            }
            case CLASS_DATE: {
                return resultSet.getDate(columnIndex);
            }
            case CLASS_SHORT: {
                return resultSet.getShort(columnIndex);
            }
            case CLASS_TIME: {
                return resultSet.getTime(columnIndex);
            }
            case CLASS_OBJECT: {
                return resultSet.getObject(columnIndex);
            }
        }
        throw new UnhandledColumnTypeException("Unhandled column type (" + (Object)((Object)this) + ")");
    }

    public void setValue(PreparedStatement insertStatement, int columnIndex, Object data, int sqlType) throws SQLException {
        if (data == null) {
            insertStatement.setNull(columnIndex, sqlType);
        } else {
            this.setStatementValue(insertStatement, columnIndex, data);
        }
    }

    private void setStatementValue(PreparedStatement insertStatement, int columnIndex, Object data) throws SQLException, UnhandledColumnTypeException {
        switch (this) {
            case CLASS_STRING: {
                insertStatement.setString(columnIndex, (String)data);
                break;
            }
            case CLASS_INTEGER: {
                insertStatement.setInt(columnIndex, (Integer)data);
                break;
            }
            case CLASS_LONG: {
                insertStatement.setLong(columnIndex, (Long)data);
                break;
            }
            case CLASS_DOUBLE: {
                insertStatement.setDouble(columnIndex, (Double)data);
                break;
            }
            case CLASS_BLOB: {
                insertStatement.setBlob(columnIndex, ((Blob)data).getBinaryStream());
                break;
            }
            case CLASS_BOOLEAN: {
                insertStatement.setBoolean(columnIndex, (Boolean)data);
                break;
            }
            case CLASS_BIGDECIMAL: {
                insertStatement.setBigDecimal(columnIndex, (BigDecimal)data);
                break;
            }
            case CLASS_TIMESTAMP: {
                insertStatement.setTimestamp(columnIndex, (Timestamp)data);
                break;
            }
            case CLASS_DATE: {
                insertStatement.setDate(columnIndex, (Date)data);
                break;
            }
            case CLASS_FLOAT: {
                insertStatement.setFloat(columnIndex, ((Float)data).floatValue());
                break;
            }
            case CLASS_SHORT: {
                insertStatement.setShort(columnIndex, (Short)data);
                break;
            }
            case CLASS_TIME: {
                insertStatement.setTime(columnIndex, (Time)data);
                break;
            }
            case CLASS_OBJECT: {
                insertStatement.setObject(columnIndex, data);
                break;
            }
            default: {
                throw new UnhandledColumnTypeException("Unhandled column type (" + (Object)((Object)this) + ")");
            }
        }
    }

    public List<Class<?>> getColumnClasses() {
        return this._columnClasses;
    }

    public static ColumnType valueOf(Class<?> columnClass) throws SQLException {
        ColumnType.init();
        ColumnType result = COLUMN_TYPES.get(columnClass);
        if (result == null) {
            throw new UnhandledColumnTypeException("Unhandled column class " + columnClass);
        }
        return result;
    }

    public boolean isNumber() {
        return Number.class.isAssignableFrom(this.getColumnClasses().get(0));
    }

    public static boolean isSupportedClass(Class<?> columnClass) throws SQLException {
        ColumnType.init();
        return COLUMN_TYPES.containsKey(columnClass);
    }

    public static boolean isSupportedClass(String className) throws SQLException {
        Class<?> clazz = ColumnType.forName(className);
        return ColumnType.isSupportedClass(clazz);
    }

    private static void init() {
        if (COLUMN_TYPES.isEmpty()) {
            for (ColumnType columnType : ColumnType.values()) {
                for (Class<?> columnClass : columnType.getColumnClasses()) {
                    COLUMN_TYPES.put(columnClass, columnType);
                }
            }
        }
    }

    public static ColumnType valueForClass(String className) throws SQLException {
        Class<?> clazz = ColumnType.forName(className);
        return ColumnType.valueOf(clazz);
    }

    private static Class<?> forName(String className) throws SQLException {
        if ("byte[]".equals(className)) {
            return Util.ByteArrayClass;
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Class not found: " + className, e);
        }
    }

    static {
        COLUMN_TYPES = new HashMap();
    }
}

