/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.meta.builder;

import de.akquinet.jbosscc.guttenbase.connector.DatabaseType;
import de.akquinet.jbosscc.guttenbase.meta.InternalDatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.builder.TableMetaDataBuilder;
import de.akquinet.jbosscc.guttenbase.meta.impl.DatabaseMetaDataImpl;
import java.util.ArrayList;
import java.util.List;

public class DatabaseMetaDataBuilder {
    private final List<TableMetaDataBuilder> _tables = new ArrayList<TableMetaDataBuilder>();
    private String _schema = "";
    private String _databaseName = "SomeDB";
    private int _majorVersion = 1;
    private int _minorVersion = 0;
    private DatabaseType _databaseType = DatabaseType.GENERIC;
    private DatabaseMetaDataImpl _result;

    public InternalDatabaseMetaData build() {
        if (this._result == null) {
            this._result = new DatabaseMetaDataImpl(this._schema, this._databaseName, this._majorVersion, this._minorVersion, this._databaseType);
            for (TableMetaDataBuilder builder : this._tables) {
                this._result.addTableMetaData(builder.build());
            }
        }
        return this._result;
    }

    public DatabaseMetaDataBuilder setDatabaseType(DatabaseType databaseType) {
        this._databaseType = databaseType;
        return this;
    }

    public DatabaseMetaDataBuilder setSchema(String schema) {
        this._schema = schema;
        return this;
    }

    public DatabaseMetaDataBuilder setDatabaseName(String databaseName) {
        this._databaseName = databaseName;
        return this;
    }

    public DatabaseMetaDataBuilder setMajorVersion(int majorVersion) {
        this._majorVersion = majorVersion;
        return this;
    }

    public DatabaseMetaDataBuilder setMinorVersion(int minorVersion) {
        this._minorVersion = minorVersion;
        return this;
    }

    public DatabaseMetaDataBuilder addTable(TableMetaDataBuilder tableMetaDataBuilder) {
        this._tables.add(tableMetaDataBuilder);
        return this;
    }
}

