/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.meta.impl;

import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.ForeignKeyMetaData;
import de.akquinet.jbosscc.guttenbase.meta.InternalColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class ColumnMetaDataImpl
implements InternalColumnMetaData {
    private static final long serialVersionUID = 1L;
    private final int _columnType;
    private final String _columnName;
    private final String _columnTypeName;
    private final String _columnClassName;
    private final boolean _isNullable;
    private final boolean _isAutoIncrement;
    private final int _precision;
    private final int _scale;
    private final TableMetaData _tableMetaData;
    private boolean _primaryKey;
    private UUID _columnId = UUID.randomUUID();

    public ColumnMetaDataImpl(int columnType, String columnName, String columnTypeName, String columnClassName, boolean isNullable, boolean isAutoIncrement, int precision, int scale, TableMetaData tableMetaData) {
        assert (columnClassName != null) : "columnClassName != null";
        assert (columnTypeName != null) : "columnTypeName != null";
        assert (columnName != null) : "columnName != null";
        assert (tableMetaData != null) : "tableMetaData != null";
        this._precision = precision;
        this._scale = scale;
        this._isAutoIncrement = isAutoIncrement;
        this._tableMetaData = tableMetaData;
        this._isNullable = isNullable;
        this._columnType = columnType;
        this._columnName = columnName;
        this._columnTypeName = columnTypeName;
        this._columnClassName = columnClassName;
    }

    @Override
    public void setPrimaryKey(boolean primaryKey) {
        this._primaryKey = primaryKey;
    }

    @Override
    public boolean isPrimaryKey() {
        return this._primaryKey;
    }

    @Override
    public int getColumnType() {
        return this._columnType;
    }

    @Override
    public String getColumnName() {
        return this._columnName;
    }

    @Override
    public String getColumnTypeName() {
        return this._columnTypeName;
    }

    @Override
    public String getColumnClassName() {
        return this._columnClassName;
    }

    @Override
    public boolean isNullable() {
        return this._isNullable;
    }

    @Override
    public boolean isAutoIncrement() {
        return this._isAutoIncrement;
    }

    @Override
    public int getPrecision() {
        return this._precision;
    }

    @Override
    public int getScale() {
        return this._scale;
    }

    @Override
    public ColumnMetaData getReferencedColumn() {
        for (ForeignKeyMetaData foreignKey : this.getTableMetaData().getForeignKeys()) {
            if (foreignKey.getReferencingColumn() != this) continue;
            return foreignKey.getReferencedColumn();
        }
        return null;
    }

    @Override
    public List<ColumnMetaData> getReferencedByColumn() {
        ArrayList<ColumnMetaData> result = new ArrayList<ColumnMetaData>();
        for (ForeignKeyMetaData foreignKey : this.getTableMetaData().getForeignKeys()) {
            if (foreignKey.getReferencedColumn() != this) continue;
            result.add(foreignKey.getReferencingColumn());
        }
        return result;
    }

    @Override
    public TableMetaData getTableMetaData() {
        return this._tableMetaData;
    }

    @Override
    public UUID getColumnId() {
        return this._columnId;
    }

    @Override
    public void setColumnId(UUID columnId) {
        this._columnId = columnId;
    }

    @Override
    public int compareTo(ColumnMetaData that) {
        return this.getColumnName().toUpperCase().compareTo(that.getColumnName().toUpperCase());
    }

    public String toString() {
        return this.getColumnName() + ":" + this.getColumnTypeName();
    }

    public int hashCode() {
        return this.getColumnName().toUpperCase().hashCode();
    }

    public boolean equals(Object obj) {
        ColumnMetaData that = (ColumnMetaData)obj;
        return this.getColumnName().equalsIgnoreCase(that.getColumnName());
    }
}

