/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.meta.impl;

import de.akquinet.jbosscc.guttenbase.connector.DatabaseType;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.InternalDatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DatabaseMetaDataImpl
implements InternalDatabaseMetaData {
    private static final long serialVersionUID = 1L;
    private final String _schema;
    private final String _databaseName;
    private final int _majorVersion;
    private final int _minorVersion;
    private final DatabaseType _databaseType;
    private final Map<String, TableMetaData> _tableMetaDataMap = new LinkedHashMap<String, TableMetaData>();

    public DatabaseMetaDataImpl(String schema, String databaseName, int majorVersion, int minorVersion, DatabaseType databaseType) {
        assert (databaseName != null) : "databaseName != null";
        assert (schema != null) : "schema != null";
        assert (databaseType != null) : "databaseType != null";
        this._schema = schema;
        this._databaseName = databaseName;
        this._majorVersion = majorVersion;
        this._minorVersion = minorVersion;
        this._databaseType = databaseType;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return this._databaseType;
    }

    @Override
    public String getSchema() {
        return this._schema;
    }

    @Override
    public String getDatabaseName() {
        return this._databaseName;
    }

    @Override
    public int getMajorVersion() {
        return this._majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this._minorVersion;
    }

    @Override
    public List<TableMetaData> getTableMetaData() {
        return new ArrayList<TableMetaData>(this._tableMetaDataMap.values());
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        assert (tableName != null) : "tableName != null";
        return this._tableMetaDataMap.get(tableName.toUpperCase());
    }

    @Override
    public void addTableMetaData(TableMetaData tableMetaData) {
        this._tableMetaDataMap.put(tableMetaData.getTableName().toUpperCase(), tableMetaData);
    }

    @Override
    public void clearTableData() {
        this._tableMetaDataMap.clear();
    }

    public int hashCode() {
        return this.getDatabaseName().toUpperCase().hashCode() + this.getSchema().toUpperCase().hashCode();
    }

    public boolean equals(Object obj) {
        DatabaseMetaData that = (DatabaseMetaData)obj;
        return this.getDatabaseName().equalsIgnoreCase(that.getDatabaseName()) && this.getSchema().equalsIgnoreCase(that.getSchema());
    }
}

