/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.meta.impl;

import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.ForeignKeyMetaData;
import de.akquinet.jbosscc.guttenbase.meta.IndexMetaData;
import de.akquinet.jbosscc.guttenbase.meta.InternalTableMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableMetaDataImpl
implements InternalTableMetaData {
    private static final long serialVersionUID = 1L;
    private final String _tableName;
    private int _rowCount;
    private final Map<String, ColumnMetaData> _columns = new LinkedHashMap<String, ColumnMetaData>();
    private final Map<String, IndexMetaData> _indexes = new LinkedHashMap<String, IndexMetaData>();
    private final Map<String, ForeignKeyMetaData> _foreignKeys = new LinkedHashMap<String, ForeignKeyMetaData>();
    private final DatabaseMetaData _databaseMetaData;

    public TableMetaDataImpl(String tableName, DatabaseMetaData databaseMetaData) {
        assert (tableName != null) : "tableName != null";
        assert (databaseMetaData != null) : "databaseMetaData != null";
        this._tableName = tableName;
        this._databaseMetaData = databaseMetaData;
    }

    @Override
    public int getRowCount() {
        return this._rowCount;
    }

    @Override
    public void setRowCount(int rowCount) {
        this._rowCount = rowCount;
    }

    @Override
    public List<ColumnMetaData> getColumnMetaData() {
        return new ArrayList<ColumnMetaData>(this._columns.values());
    }

    @Override
    public ColumnMetaData getColumnMetaData(String columnName) {
        return this._columns.get(columnName.toUpperCase());
    }

    @Override
    public void addColumn(ColumnMetaData columnMetaData) {
        assert (columnMetaData != null) : "columnMetaData != null";
        this._columns.put(columnMetaData.getColumnName().toUpperCase(), columnMetaData);
    }

    @Override
    public int getColumnCount() {
        return this.getColumnMetaData().size();
    }

    @Override
    public IndexMetaData getIndexMetaData(String indexName) {
        return this._indexes.get(indexName.toUpperCase());
    }

    @Override
    public List<IndexMetaData> getIndexes() {
        return new ArrayList<IndexMetaData>(this._indexes.values());
    }

    @Override
    public List<ForeignKeyMetaData> getForeignKeys() {
        return new ArrayList<ForeignKeyMetaData>(this._foreignKeys.values());
    }

    @Override
    public void addIndex(IndexMetaData indexMetaData) {
        this._indexes.put(indexMetaData.getIndexName().toUpperCase(), indexMetaData);
    }

    @Override
    public void addForeignKey(ForeignKeyMetaData fkMetaData) {
        this._foreignKeys.put(fkMetaData.getForeignKeyName().toUpperCase(), fkMetaData);
    }

    @Override
    public List<ColumnMetaData> getPrimaryKeyColumns() {
        ArrayList<ColumnMetaData> result = new ArrayList<ColumnMetaData>();
        for (ColumnMetaData columnMetaData : this.getColumnMetaData()) {
            if (!columnMetaData.isPrimaryKey()) continue;
            result.add(columnMetaData);
        }
        return result;
    }

    @Override
    public List<IndexMetaData> getIndexesForColumn(ColumnMetaData columnMetaData) {
        ArrayList<IndexMetaData> result = new ArrayList<IndexMetaData>();
        for (IndexMetaData index : this.getIndexes()) {
            for (ColumnMetaData column : index.getColumnMetaData()) {
                if (!column.equals(columnMetaData)) continue;
                result.add(index);
            }
        }
        return result;
    }

    @Override
    public String getTableName() {
        return this._tableName;
    }

    @Override
    public DatabaseMetaData getDatabaseMetaData() {
        return this._databaseMetaData;
    }

    @Override
    public void clearColumns() {
        this._columns.clear();
        this._indexes.clear();
        this._foreignKeys.clear();
    }

    @Override
    public int compareTo(TableMetaData that) {
        return this.getTableName().toUpperCase().compareTo(that.getTableName().toUpperCase());
    }

    public String toString() {
        return this.getTableName();
    }

    public int hashCode() {
        return this.getTableName().toUpperCase().hashCode();
    }

    public boolean equals(Object obj) {
        TableMetaData that = (TableMetaData)obj;
        return this.getTableName().equalsIgnoreCase(that.getTableName());
    }
}

