/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.repository.impl;

import de.akquinet.jbosscc.guttenbase.configuration.SourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.TargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.DerbySourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.DerbyTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.GenericSourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.GenericTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.H2DbSourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.H2DbTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.HsqldbSourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.HsqldbTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.MsAccessSourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.MsAccessTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.MsSqlSourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.MsSqlTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.MySqlSourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.MySqlTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.OracleSourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.OracleTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.PostgresqlSourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.impl.PostgresqlTargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.connector.Connector;
import de.akquinet.jbosscc.guttenbase.connector.ConnectorInfo;
import de.akquinet.jbosscc.guttenbase.connector.DatabaseType;
import de.akquinet.jbosscc.guttenbase.export.ExportDumpDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.export.ImportDumpDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.hints.ConnectorHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultColumnDataMapperProviderHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultColumnMapperHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultColumnNameMapperHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultColumnOrderHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultColumnTypeResolverListHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultDatabaseTableFilterHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultEntityTableCheckerHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultExportDumpExtraInformationHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultExporterFactoryHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultImportDumpExtraInformationHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultImporterFactoryHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultMaxNumberOfDataItemsHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultNumberOfCheckedTableDataHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultNumberOfRowsPerBatchHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultRepositoryColumnFilterHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultRepositoryTableFilterHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultSplitColumnHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultTableMapperHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultTableNameMapperHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultTableOrderHint;
import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultZipExporterClassResourcesHint;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.IndexMetaData;
import de.akquinet.jbosscc.guttenbase.meta.InternalDatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.InternalTableMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.repository.RepositoryColumnFilter;
import de.akquinet.jbosscc.guttenbase.repository.RepositoryTableFilter;
import de.akquinet.jbosscc.guttenbase.utils.Util;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ConnectorRepositoryImpl
implements ConnectorRepository {
    private static final long serialVersionUID = 1L;
    private final Map<String, ConnectorInfo> _connectionInfoMap = new TreeMap<String, ConnectorInfo>();
    private final Map<DatabaseType, SourceDatabaseConfiguration> _sourceDatabaseConfigurationMap = new HashMap<DatabaseType, SourceDatabaseConfiguration>();
    private final Map<DatabaseType, TargetDatabaseConfiguration> _targetDatabaseConfigurationMap = new HashMap<DatabaseType, TargetDatabaseConfiguration>();
    private final Map<String, DatabaseMetaData> _databaseMetaDataMap = new HashMap<String, DatabaseMetaData>();
    private final Map<String, Map<Class<?>, ConnectorHint<?>>> _connectionHintMap = new HashMap();

    public ConnectorRepositoryImpl() {
        this.initDefaultConfiguration();
    }

    @Override
    public void addConnectionInfo(String connectorId, ConnectorInfo connectionInfo) {
        assert (connectorId != null) : "connectorId != null";
        assert (connectionInfo != null) : "connectionInfo != null";
        this._connectionInfoMap.put(connectorId, connectionInfo);
        this.initDefaultHints(connectorId);
    }

    @Override
    public void removeConnectionInfo(String connectorId) {
        assert (connectorId != null) : "connectorId != null";
        this._connectionInfoMap.remove(connectorId);
        this._connectionHintMap.remove(connectorId);
        this._databaseMetaDataMap.remove(connectorId);
    }

    @Override
    public <T> void addConnectorHint(String connectorId, ConnectorHint<T> hint) {
        assert (connectorId != null) : "connectorId != null";
        assert (hint != null) : "hint != null";
        this.getConnectionInfo(connectorId);
        Map<Class<?>, ConnectorHint<?>> hintMap = this._connectionHintMap.get(connectorId);
        if (hintMap == null) {
            hintMap = new HashMap();
            this._connectionHintMap.put(connectorId, hintMap);
        }
        hintMap.put(hint.getConnectorHintType(), hint);
    }

    @Override
    public <T> void removeConnectorHint(String connectorId, Class<T> connectionInfoHintType) {
        assert (connectorId != null) : "connectorId != null";
        assert (connectionInfoHintType != null) : "connectionInfoHintType != null";
        Map<Class<?>, ConnectorHint<?>> hintMap = this._connectionHintMap.get(connectorId);
        if (hintMap != null) {
            hintMap.remove(connectionInfoHintType);
        }
    }

    @Override
    public <T> ConnectorHint<T> getConnectorHint(String connectorId, Class<T> connectionInfoHintType) {
        assert (connectorId != null) : "connectorId != null";
        assert (connectionInfoHintType != null) : "connectionInfoHintType != null";
        Map<Class<?>, ConnectorHint<?>> hintMap = this._connectionHintMap.get(connectorId);
        if (hintMap == null) {
            throw new IllegalStateException("No hints defined for " + connectorId);
        }
        return hintMap.get(connectionInfoHintType);
    }

    @Override
    public ConnectorInfo getConnectionInfo(String connectorId) {
        assert (connectorId != null) : "connectorId != null";
        ConnectorInfo connectionInfo = this._connectionInfoMap.get(connectorId);
        if (connectionInfo == null) {
            throw new IllegalStateException("Connector not configured: " + connectorId);
        }
        return connectionInfo;
    }

    @Override
    public DatabaseMetaData getDatabaseMetaData(String connectorId) throws SQLException {
        assert (connectorId != null) : "connectorId != null";
        DatabaseMetaData databaseMetaData = this._databaseMetaDataMap.get(connectorId);
        if (databaseMetaData == null) {
            Connector connector = this.createConnector(connectorId);
            databaseMetaData = connector.retrieveDatabaseMetaData();
            this._databaseMetaDataMap.put(connectorId, databaseMetaData);
        }
        return this.createResultWithFilteredTables(connectorId, databaseMetaData);
    }

    @Override
    public void refreshDatabaseMetaData(String connectorId) {
        assert (connectorId != null) : "connectorId != null";
        this._databaseMetaDataMap.remove(connectorId);
    }

    @Override
    public Connector createConnector(String connectorId) {
        assert (connectorId != null) : "connectorId != null";
        ConnectorInfo connectionInfo = this.getConnectionInfo(connectorId);
        return connectionInfo.createConnector(this, connectorId);
    }

    @Override
    public SourceDatabaseConfiguration getSourceDatabaseConfiguration(String connectorId) {
        assert (connectorId != null) : "connectorId != null";
        ConnectorInfo connectionInfo = this.getConnectionInfo(connectorId);
        DatabaseType databaseType = connectionInfo.getDatabaseType();
        SourceDatabaseConfiguration result = this._sourceDatabaseConfigurationMap.get((Object)databaseType);
        if (result == null) {
            throw new IllegalStateException("Unhandled source connector data base type: " + (Object)((Object)databaseType));
        }
        return result;
    }

    @Override
    public void addSourceDatabaseConfiguration(DatabaseType databaseType, SourceDatabaseConfiguration sourceDatabaseConfiguration) {
        assert (databaseType != null) : "databaseType != null";
        assert (sourceDatabaseConfiguration != null) : "sourceDatabaseConfiguration != null";
        this._sourceDatabaseConfigurationMap.put(databaseType, sourceDatabaseConfiguration);
    }

    @Override
    public void addTargetDatabaseConfiguration(DatabaseType databaseType, TargetDatabaseConfiguration targetDatabaseConfiguration) {
        assert (targetDatabaseConfiguration != null) : "targetDatabaseConfiguration != null";
        assert (databaseType != null) : "databaseType != null";
        this._targetDatabaseConfigurationMap.put(databaseType, targetDatabaseConfiguration);
    }

    @Override
    public TargetDatabaseConfiguration getTargetDatabaseConfiguration(String connectorId) {
        assert (connectorId != null) : "connectorId != null";
        ConnectorInfo connectionInfo = this.getConnectionInfo(connectorId);
        DatabaseType databaseType = connectionInfo.getDatabaseType();
        TargetDatabaseConfiguration result = this._targetDatabaseConfigurationMap.get((Object)databaseType);
        if (result == null) {
            throw new IllegalStateException("Unhandled target connector data base type: " + (Object)((Object)databaseType));
        }
        return result;
    }

    @Override
    public List<String> getConnectorIds() {
        return new ArrayList<String>(this._connectionInfoMap.keySet());
    }

    private DatabaseMetaData createResultWithFilteredTables(String connectorId, DatabaseMetaData databaseMetaData) throws SQLException {
        InternalDatabaseMetaData result = Util.copyObject(InternalDatabaseMetaData.class, (InternalDatabaseMetaData)databaseMetaData);
        RepositoryTableFilter tableFilter = this.getConnectorHint(connectorId, RepositoryTableFilter.class).getValue();
        RepositoryColumnFilter columnFilter = this.getConnectorHint(connectorId, RepositoryColumnFilter.class).getValue();
        result.clearTableData();
        for (TableMetaData tableMetaData : databaseMetaData.getTableMetaData()) {
            if (!tableFilter.accept(tableMetaData)) continue;
            InternalTableMetaData newTableMetaData = Util.copyObject(InternalTableMetaData.class, (InternalTableMetaData)tableMetaData);
            newTableMetaData.clearColumns();
            for (ColumnMetaData columnMetaData : tableMetaData.getColumnMetaData()) {
                if (!columnFilter.accept(columnMetaData)) continue;
                newTableMetaData.addColumn(columnMetaData);
                List<IndexMetaData> indexes = tableMetaData.getIndexesForColumn(columnMetaData);
                for (IndexMetaData indexMetaData : indexes) {
                    newTableMetaData.addIndex(indexMetaData);
                }
            }
            result.addTableMetaData(newTableMetaData);
        }
        return result;
    }

    private void initDefaultConfiguration() {
        this.addSourceDatabaseConfiguration(DatabaseType.GENERIC, new GenericSourceDatabaseConfiguration(this));
        this.addSourceDatabaseConfiguration(DatabaseType.MSSQL, new MsSqlSourceDatabaseConfiguration(this));
        this.addSourceDatabaseConfiguration(DatabaseType.MYSQL, new MySqlSourceDatabaseConfiguration(this));
        this.addSourceDatabaseConfiguration(DatabaseType.POSTGRESQL, new PostgresqlSourceDatabaseConfiguration(this));
        this.addSourceDatabaseConfiguration(DatabaseType.ORACLE, new OracleSourceDatabaseConfiguration(this));
        this.addSourceDatabaseConfiguration(DatabaseType.IMPORT_DUMP, new ImportDumpDatabaseConfiguration(this));
        this.addSourceDatabaseConfiguration(DatabaseType.HSQLDB, new HsqldbSourceDatabaseConfiguration(this));
        this.addSourceDatabaseConfiguration(DatabaseType.H2DB, new H2DbSourceDatabaseConfiguration(this));
        this.addSourceDatabaseConfiguration(DatabaseType.DERBY, new DerbySourceDatabaseConfiguration(this));
        this.addSourceDatabaseConfiguration(DatabaseType.MS_ACCESS, new MsAccessSourceDatabaseConfiguration(this));
        this.addTargetDatabaseConfiguration(DatabaseType.GENERIC, new GenericTargetDatabaseConfiguration(this));
        this.addTargetDatabaseConfiguration(DatabaseType.MSSQL, new MsSqlTargetDatabaseConfiguration(this));
        this.addTargetDatabaseConfiguration(DatabaseType.MYSQL, new MySqlTargetDatabaseConfiguration(this));
        this.addTargetDatabaseConfiguration(DatabaseType.ORACLE, new OracleTargetDatabaseConfiguration(this));
        this.addTargetDatabaseConfiguration(DatabaseType.POSTGRESQL, new PostgresqlTargetDatabaseConfiguration(this));
        this.addTargetDatabaseConfiguration(DatabaseType.EXPORT_DUMP, new ExportDumpDatabaseConfiguration(this));
        this.addTargetDatabaseConfiguration(DatabaseType.HSQLDB, new HsqldbTargetDatabaseConfiguration(this));
        this.addTargetDatabaseConfiguration(DatabaseType.H2DB, new H2DbTargetDatabaseConfiguration(this));
        this.addTargetDatabaseConfiguration(DatabaseType.DERBY, new DerbyTargetDatabaseConfiguration(this));
        this.addTargetDatabaseConfiguration(DatabaseType.MS_ACCESS, new MsAccessTargetDatabaseConfiguration(this));
    }

    private void initDefaultHints(String connectorId) {
        this.addConnectorHint(connectorId, new DefaultRepositoryTableFilterHint());
        this.addConnectorHint(connectorId, new DefaultDatabaseTableFilterHint());
        this.addConnectorHint(connectorId, new DefaultNumberOfRowsPerBatchHint());
        this.addConnectorHint(connectorId, new DefaultNumberOfCheckedTableDataHint());
        this.addConnectorHint(connectorId, new DefaultMaxNumberOfDataItemsHint());
        this.addConnectorHint(connectorId, new DefaultSplitColumnHint());
        this.addConnectorHint(connectorId, new DefaultColumnTypeResolverListHint());
        this.addConnectorHint(connectorId, new DefaultColumnNameMapperHint());
        this.addConnectorHint(connectorId, new DefaultEntityTableCheckerHint());
        this.addConnectorHint(connectorId, new DefaultTableNameMapperHint());
        this.addConnectorHint(connectorId, new DefaultExporterFactoryHint());
        this.addConnectorHint(connectorId, new DefaultImporterFactoryHint());
        this.addConnectorHint(connectorId, new DefaultZipExporterClassResourcesHint());
        this.addConnectorHint(connectorId, new DefaultColumnDataMapperProviderHint());
        this.addConnectorHint(connectorId, new DefaultTableOrderHint());
        this.addConnectorHint(connectorId, new DefaultColumnOrderHint());
        this.addConnectorHint(connectorId, new DefaultTableMapperHint());
        this.addConnectorHint(connectorId, new DefaultColumnMapperHint());
        this.addConnectorHint(connectorId, new DefaultRepositoryColumnFilterHint());
        this.addConnectorHint(connectorId, new DefaultExportDumpExtraInformationHint());
        this.addConnectorHint(connectorId, new DefaultImportDumpExtraInformationHint());
    }
}

