/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.repository.impl;

import de.akquinet.jbosscc.guttenbase.connector.ConnectorInfo;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.InternalColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.InternalDatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.InternalIndexMetaData;
import de.akquinet.jbosscc.guttenbase.meta.InternalTableMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.meta.impl.ColumnMetaDataImpl;
import de.akquinet.jbosscc.guttenbase.meta.impl.DatabaseMetaDataImpl;
import de.akquinet.jbosscc.guttenbase.meta.impl.ForeignKeyMetaDataImpl;
import de.akquinet.jbosscc.guttenbase.meta.impl.IndexMetaDataImpl;
import de.akquinet.jbosscc.guttenbase.meta.impl.TableMetaDataImpl;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.repository.DatabaseTableFilter;
import de.akquinet.jbosscc.guttenbase.utils.Util;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DatabaseMetaDataInspectorTool {
    private static final Logger LOG = Logger.getLogger(DatabaseMetaDataInspectorTool.class);
    public static final String ERROR = "Error while checking if table exists: ";
    public static final String TABLE_PLACEHOLDER = "<table>";
    public static final String SELECT_COUNT_STATEMENT = "SELECT COUNT(*) FROM <table>";
    public static final String SELECT_STATEMENT = "SELECT * FROM <table> WHERE 1 > 2";
    public static final String NO_RESULT = "No result returned";
    private final ConnectorRepository _connectorRepository;
    private final String _connectorId;

    public DatabaseMetaDataInspectorTool(ConnectorRepository connectorRepository, String connectorId) {
        assert (connectorId != null) : "connectorId != null";
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
        this._connectorId = connectorId;
    }

    public de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData getDatabaseMetaData(Connection connection) throws SQLException {
        LOG.info((Object)("Retrieving meta data for " + this._connectorId));
        ConnectorInfo connectionInfo = this._connectorRepository.getConnectionInfo(this._connectorId);
        String schema = connectionInfo.getSchema();
        String schemaPattern = "".equals(Util.trim(schema)) ? null : schema;
        DatabaseMetaData metaData = connection.getMetaData();
        DatabaseMetaDataImpl result = new DatabaseMetaDataImpl(schema, this.getProductName(metaData), this.getMajorVersion(metaData), this.getMinorVersion(metaData), connectionInfo.getDatabaseType());
        this.loadTables(result, metaData, schemaPattern);
        this.updateTableMetaData(connection, metaData, result, schemaPattern);
        LOG.info((Object)("Retrieving meta data for " + this._connectorId + " DONE"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTableMetaData(Connection connection, DatabaseMetaData metaData, de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData databaseMetaData, String schemaPattern) throws SQLException {
        InternalTableMetaData tableMetaData;
        Statement statement = connection.createStatement();
        try {
            for (TableMetaData table : databaseMetaData.getTableMetaData()) {
                tableMetaData = (InternalTableMetaData)table;
                this.updateTableWithRowCount(statement, tableMetaData, schemaPattern);
                this.updateTableMetaDataWithColumnInformation(statement, tableMetaData, schemaPattern);
            }
        }
        finally {
            statement.close();
        }
        try {
            for (TableMetaData table : databaseMetaData.getTableMetaData()) {
                tableMetaData = (TableMetaDataImpl)table;
                this.updateColumnsWithPrimaryKeyInformation(metaData, tableMetaData, schemaPattern);
                this.updateColumnsWithForeignKeyInformation(metaData, databaseMetaData, tableMetaData, schemaPattern);
                this.updateTableWithIndexInformation(metaData, databaseMetaData, tableMetaData, schemaPattern);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Could not update additional schema information", (Throwable)e);
        }
    }

    private void updateColumnsWithForeignKeyInformation(DatabaseMetaData metaData, de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData databaseMetaData, TableMetaData table, String schemaPattern) throws SQLException {
        ResultSet resultSet = metaData.getExportedKeys(null, schemaPattern, table.getTableName());
        while (resultSet.next()) {
            String pkTableName = resultSet.getString("PKTABLE_NAME");
            String pkColumnName = resultSet.getString("PKCOLUMN_NAME");
            String fkTableName = resultSet.getString("FKTABLE_NAME");
            String fkColumnName = resultSet.getString("FKCOLUMN_NAME");
            String fkName = resultSet.getString("FK_NAME");
            InternalTableMetaData pkTableMetaData = (InternalTableMetaData)databaseMetaData.getTableMetaData(pkTableName);
            InternalTableMetaData fkTableMetaData = (InternalTableMetaData)databaseMetaData.getTableMetaData(fkTableName);
            ColumnMetaData pkColumn = pkTableMetaData.getColumnMetaData(pkColumnName);
            ColumnMetaData fkColumn = fkTableMetaData.getColumnMetaData(fkColumnName);
            pkTableMetaData.addForeignKey(new ForeignKeyMetaDataImpl(pkTableMetaData, fkName, fkColumn, pkColumn));
            fkTableMetaData.addForeignKey(new ForeignKeyMetaDataImpl(fkTableMetaData, fkName, fkColumn, pkColumn));
        }
        resultSet.close();
    }

    private void updateTableWithIndexInformation(DatabaseMetaData metaData, de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData databaseMetaData, InternalTableMetaData table, String schemaPattern) throws SQLException {
        ResultSet resultSet = metaData.getIndexInfo(null, schemaPattern, table.getTableName(), false, true);
        while (resultSet.next()) {
            boolean nonUnique = resultSet.getBoolean("NON_UNIQUE");
            String indexName = resultSet.getString("INDEX_NAME");
            String columnName = resultSet.getString("COLUMN_NAME");
            String ascOrDesc = resultSet.getString("ASC_OR_DESC");
            if (columnName == null) continue;
            InternalIndexMetaData indexMetaData = (InternalIndexMetaData)table.getIndexMetaData(indexName);
            if (indexMetaData == null) {
                boolean ascending = ascOrDesc == null || "A".equals(ascOrDesc);
                boolean unique = !nonUnique;
                indexMetaData = new IndexMetaDataImpl(table, indexName, ascending, unique);
                table.addIndex(indexMetaData);
            }
            ColumnMetaData column = table.getColumnMetaData(columnName);
            indexMetaData.addColumn(column);
        }
        resultSet.close();
    }

    private void updateColumnsWithPrimaryKeyInformation(DatabaseMetaData metaData, TableMetaData table, String schemaPattern) throws SQLException {
        ResultSet resultSet = metaData.getPrimaryKeys(null, schemaPattern, table.getTableName());
        while (resultSet.next()) {
            String pkName = resultSet.getString("PK_NAME");
            String columnName = resultSet.getString("COLUMN_NAME");
            if (pkName == null) continue;
            InternalColumnMetaData columnMetaData = (InternalColumnMetaData)table.getColumnMetaData(columnName);
            if (columnMetaData == null) {
                throw new IllegalStateException("No column meta data for " + columnName);
            }
            columnMetaData.setPrimaryKey(true);
        }
        resultSet.close();
    }

    private void updateTableMetaDataWithColumnInformation(Statement statement, InternalTableMetaData tableMetaData, String schemaPattern) throws SQLException {
        String tableName = this.escapeTableName(tableMetaData, schemaPattern);
        LOG.debug((Object)("Retrieving column information for " + tableName));
        String selectSQL = SELECT_STATEMENT.replace(TABLE_PLACEHOLDER, tableName);
        ResultSet resultSet = statement.executeQuery(selectSQL);
        ResultSetMetaData meta = resultSet.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnTypeName = meta.getColumnTypeName(i);
            int columnType = meta.getColumnType(i);
            String columnName = meta.getColumnName(i);
            String columnClassName = meta.getColumnClassName(i);
            boolean isNullable = meta.isNullable(i) != 0;
            boolean isAutoIncrement = meta.isAutoIncrement(i);
            int precision = meta.getPrecision(i);
            int scale = meta.getScale(i);
            tableMetaData.addColumn(new ColumnMetaDataImpl(columnType, columnName, columnTypeName, columnClassName, isNullable, isAutoIncrement, precision, scale, tableMetaData));
        }
        resultSet.close();
    }

    private String escapeTableName(InternalTableMetaData tableMetaData, String schemaPattern) {
        String tableName = (schemaPattern == null ? "" : schemaPattern + ".") + tableMetaData.getTableName();
        if (tableName.contains(" ")) {
            tableName = "\"" + tableName + "\"";
        }
        return tableName;
    }

    private void updateTableWithRowCount(Statement statement, InternalTableMetaData tableMetaData, String schemaPattern) throws SQLException {
        String tableName = this.escapeTableName(tableMetaData, schemaPattern);
        LOG.debug((Object)("Retrieving row count for " + tableName));
        String countSQL = SELECT_COUNT_STATEMENT.replace(TABLE_PLACEHOLDER, tableName);
        ResultSet countResultSet = statement.executeQuery(countSQL);
        countResultSet.next();
        int totalCount = countResultSet.getInt(1);
        countResultSet.close();
        tableMetaData.setRowCount(totalCount);
    }

    private void loadTables(InternalDatabaseMetaData databaseMetaData, DatabaseMetaData metaData, String schemaPattern) throws SQLException {
        LOG.debug((Object)("Searching tables in schema " + schemaPattern));
        ResultSet rs = metaData.getTables(null, null, "%", null);
        DatabaseTableFilter tableNameFilter = this._connectorRepository.getConnectorHint(this._connectorId, DatabaseTableFilter.class).getValue();
        while (rs.next()) {
            TableMetaDataImpl tableMetaData;
            String tableType = rs.getString("TABLE_TYPE");
            if (!"TABLE".equals(tableType)) continue;
            String tableName = rs.getString("TABLE_NAME");
            String schemaName = rs.getString("TABLE_SCHEM");
            if (schemaPattern != null && !schemaPattern.equalsIgnoreCase(schemaName) || !tableNameFilter.accept(tableMetaData = new TableMetaDataImpl(tableName, databaseMetaData))) continue;
            databaseMetaData.addTableMetaData(tableMetaData);
        }
        LOG.debug((Object)("Found tables: " + databaseMetaData.getTableMetaData()));
    }

    private String getProductName(DatabaseMetaData metaData) {
        try {
            return metaData.getDatabaseProductName();
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not get product name:" + e.getMessage()));
            return "Unknown";
        }
    }

    private int getMinorVersion(DatabaseMetaData metaData) throws SQLException {
        try {
            return metaData.getDatabaseMinorVersion();
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not get minor version:" + e.getMessage()));
            return 0;
        }
    }

    private int getMajorVersion(DatabaseMetaData metaData) throws SQLException {
        try {
            return metaData.getDatabaseMajorVersion();
        }
        catch (Exception e) {
            LOG.warn((Object)("Could not get major version:" + e.getMessage()));
            return 0;
        }
    }
}

