/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.repository.impl;

import de.akquinet.jbosscc.guttenbase.connector.DatabaseType;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnTypeResolver;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.ColumnType;
import java.sql.SQLException;

public class HeuristicColumnTypeResolver
implements ColumnTypeResolver {
    @Override
    public ColumnType getColumnType(ColumnMetaData columnMetaData) throws SQLException {
        DatabaseType databaseType;
        String columnType = columnMetaData.getColumnTypeName().toUpperCase();
        ColumnType result = this.checkDatabaseSpecificTypes(columnType, databaseType = columnMetaData.getTableMetaData().getDatabaseMetaData().getDatabaseType());
        if (result == null) {
            if (columnType.endsWith("CHAR") || columnType.endsWith("TEXT") || columnType.startsWith("CHAR")) {
                return ColumnType.CLASS_STRING;
            }
            if ("BIGINT".equals(columnType)) {
                return ColumnType.CLASS_LONG;
            }
            if (columnType.startsWith("NUMERIC") || "DECIMAL".equals(columnType)) {
                return ColumnType.CLASS_BIGDECIMAL;
            }
            if ("INT2".equals(columnType) || "SMALLINT".equals(columnType)) {
                return ColumnType.CLASS_SHORT;
            }
            if (columnType.startsWith("INT") || columnType.endsWith("INT") || columnType.equals("COUNTER")) {
                return ColumnType.CLASS_INTEGER;
            }
            if (columnType.endsWith("BLOB") || columnType.equals("IMAGE")) {
                return ColumnType.CLASS_BLOB;
            }
            if (columnType.equals("BIT") || columnType.startsWith("BOOL")) {
                return ColumnType.CLASS_BOOLEAN;
            }
            if (columnType.equals("BYTEA")) {
                return ColumnType.CLASS_OBJECT;
            }
            return ColumnType.valueForClass(columnMetaData.getColumnClassName());
        }
        return result;
    }

    private ColumnType checkDatabaseSpecificTypes(String columnType, DatabaseType databaseType) {
        switch (databaseType) {
            case POSTGRESQL: {
                if (columnType.equals("BIT")) {
                    return ColumnType.CLASS_STRING;
                }
                if ("INT8".equals(columnType)) {
                    return ColumnType.CLASS_BIGDECIMAL;
                }
                if (!columnType.equals("OID")) break;
                return ColumnType.CLASS_BLOB;
            }
            case ORACLE: {
                if (columnType.equals("CLOB")) {
                    return ColumnType.CLASS_STRING;
                }
                if (!columnType.equals("TIMESTAMP")) break;
                return ColumnType.CLASS_TIMESTAMP;
            }
        }
        return null;
    }
}

