/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.sql;

import de.akquinet.jbosscc.guttenbase.sql.SQLTokenType;
import java.util.ArrayList;
import java.util.List;

public class SQLLexer {
    private static final int EOF = -1;
    private final String _sql;
    private int _currentIndex = 0;
    private boolean _withinString;

    public SQLLexer(List<String> lines) {
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            builder.append(line.trim());
            builder.append('\n');
        }
        this._sql = builder.toString();
    }

    public List<String> parse() {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        block12: while (this.hasNext()) {
            SQLTokenType nextToken = this.nextToken();
            switch (nextToken) {
                case END_OF_LINE: 
                case WHITESPACE: {
                    this.read();
                    builder.append(' ');
                    while (this.nextToken() == SQLTokenType.WHITESPACE) {
                        this.read();
                    }
                    continue block12;
                }
                case END_OF_STATEMENT: {
                    this.read();
                    result.add(builder.toString().trim());
                    builder.setLength(0);
                    continue block12;
                }
                case SINGLE_LINE_COMMENT_START: {
                    this.seekToken(SQLTokenType.END_OF_LINE);
                    continue block12;
                }
                case MULTI_LINE_COMMENT_START: {
                    this.seekToken(SQLTokenType.MULTI_LINE_COMMENT_END);
                    continue block12;
                }
                case MULTI_LINE_COMMENT_END: {
                    this.read();
                    this.read();
                    continue block12;
                }
                case ESCAPED_STRING_DELIMITER: {
                    builder.append((char)this.read());
                    builder.append((char)this.read());
                    continue block12;
                }
                case EOF: {
                    this.read();
                    continue block12;
                }
                case OTHER: {
                    builder.append((char)this.read());
                    continue block12;
                }
                case STRING_DELIMITER_START: {
                    builder.append((char)this.read());
                    this._withinString = true;
                    continue block12;
                }
                case STRING_DELIMITER_END: {
                    builder.append((char)this.read());
                    this._withinString = false;
                    continue block12;
                }
            }
            throw new IllegalStateException("unhandled case: " + (Object)((Object)nextToken));
        }
        return result;
    }

    private void seekToken(SQLTokenType tokenType) {
        SQLTokenType nextToken;
        do {
            this.read();
        } while ((nextToken = this.nextToken()) != tokenType && nextToken != SQLTokenType.EOF);
    }

    private SQLTokenType nextToken() {
        int ch1 = this.read();
        int ch2 = this.read();
        this.unread(2);
        if (ch1 < 0) {
            return SQLTokenType.EOF;
        }
        if (!this._withinString && ch1 == 45 && ch2 == 45) {
            return SQLTokenType.SINGLE_LINE_COMMENT_START;
        }
        if (!this._withinString && ch1 == 47 && ch2 == 42) {
            return SQLTokenType.MULTI_LINE_COMMENT_START;
        }
        if (!this._withinString && ch1 == 42 && ch2 == 47) {
            return SQLTokenType.MULTI_LINE_COMMENT_END;
        }
        if (!this._withinString && ch1 == 59) {
            return SQLTokenType.END_OF_STATEMENT;
        }
        if (!this._withinString && ch1 == 10) {
            return SQLTokenType.END_OF_LINE;
        }
        if (!this._withinString && ch1 == 13 || ch1 == 9 || ch1 == 32) {
            return SQLTokenType.WHITESPACE;
        }
        if (ch1 == 39 && ch2 == 39) {
            return SQLTokenType.ESCAPED_STRING_DELIMITER;
        }
        if (ch1 == 39 && ch2 != 39) {
            if (this._withinString) {
                return SQLTokenType.STRING_DELIMITER_END;
            }
            return SQLTokenType.STRING_DELIMITER_START;
        }
        return SQLTokenType.OTHER;
    }

    private void unread(int count) {
        this._currentIndex -= count;
    }

    private boolean hasNext() {
        return this._currentIndex < this._sql.length();
    }

    private int read() {
        int index = this._currentIndex++;
        if (!this.hasNext()) {
            return -1;
        }
        return this._sql.charAt(index);
    }
}

