/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.statements;

import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.statements.AbstractStatementCreator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractInsertStatementCreator
extends AbstractStatementCreator {
    public static final String INSERT_INTO = "INSERT INTO ";

    public AbstractInsertStatementCreator(ConnectorRepository connectorRepository, String connectorId) {
        super(connectorRepository, connectorId);
    }

    public PreparedStatement createInsertStatement(String sourceConnectorId, TableMetaData sourceTableMetaData, String targetTableName, TableMetaData targetTableMetaData, Connection destConnection, int numberOfRowsPerBatch, boolean useMultipleValuesClauses) throws SQLException {
        assert (numberOfRowsPerBatch > 0) : "numberOfValueClauses > 0";
        int numberOfValuesClauses = useMultipleValuesClauses ? numberOfRowsPerBatch : 1;
        String sql = this.createSQL(sourceConnectorId, sourceTableMetaData, targetTableName, targetTableMetaData, numberOfValuesClauses);
        LOG.debug((Object)("Create INSERT statement " + sql));
        return destConnection.prepareStatement(sql);
    }

    private String createValueTuples(int numberOfValuesClauses, int columnCount) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < numberOfValuesClauses; ++i) {
            buf.append('(');
            for (int j = 0; j < columnCount; ++j) {
                buf.append('?');
                if (j >= columnCount - 1) continue;
                buf.append(',');
            }
            buf.append(')');
            if (i >= numberOfValuesClauses - 1) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    private String createSQL(String sourceConnectorId, TableMetaData sourceTableMetaData, String targetTableName, TableMetaData targetTableMetaData, int numberOfValueClauses) throws SQLException {
        List<ColumnMetaData> columns = this.getMappedTargetColumns(sourceTableMetaData, targetTableMetaData, sourceConnectorId);
        StringBuilder buf = new StringBuilder(INSERT_INTO + targetTableName + " (");
        buf.append(this.createColumnClause(columns));
        buf.append(") VALUES ");
        buf.append(this.createValueTuples(numberOfValueClauses, columns.size()));
        buf.append(this.createWhereClause(targetTableMetaData));
        return buf.toString();
    }
}

