/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.statements;

import de.akquinet.jbosscc.guttenbase.hints.ColumnOrderHint;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.statements.AbstractStatementCreator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractSelectStatementCreator
extends AbstractStatementCreator {
    public static final String FROM = " FROM ";

    public AbstractSelectStatementCreator(ConnectorRepository connectorRepository, String connectorId) {
        super(connectorRepository, connectorId);
    }

    public PreparedStatement createSelectStatement(String tableName, TableMetaData tableMetaData, Connection connection) throws SQLException {
        List<ColumnMetaData> columns = ColumnOrderHint.getSortedColumns(this._connectorRepository, this._connectorId, tableMetaData);
        String sql = this.createSQL(tableName, tableMetaData, columns);
        LOG.debug((Object)("Create SELECT statement " + sql));
        return connection.prepareStatement(sql);
    }

    public PreparedStatement createMappedSelectStatement(TableMetaData sourceTableMetaData, String tableName, TableMetaData targetTableMetaData, Connection connection, String sourceConnectorId) throws SQLException {
        List<ColumnMetaData> columns = this.getMappedTargetColumns(sourceTableMetaData, targetTableMetaData, sourceConnectorId);
        String sql = this.createSQL(tableName, targetTableMetaData, columns);
        return connection.prepareStatement(sql);
    }

    protected String createOrderBy(TableMetaData tableMetaData) throws SQLException {
        return "";
    }

    private String createSQL(String tableName, TableMetaData tableMetaData, List<ColumnMetaData> columns) throws SQLException {
        StringBuilder buf = new StringBuilder("SELECT ");
        buf.append(this.createColumnClause(columns));
        buf.append(FROM + tableName);
        buf.append(" " + this.createWhereClause(tableMetaData));
        buf.append(" " + this.createOrderBy(tableMetaData));
        return buf.toString();
    }
}

