/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.statements;

import de.akquinet.jbosscc.guttenbase.hints.ColumnOrderHint;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnMapper;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnNameMapper;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractStatementCreator {
    protected static final Logger LOG = Logger.getLogger(AbstractStatementCreator.class);
    protected final ConnectorRepository _connectorRepository;
    protected final String _connectorId;
    protected final ColumnNameMapper _columnNameMapper;

    public AbstractStatementCreator(ConnectorRepository connectorRepository, String connectorId) {
        assert (connectorRepository != null) : "connectorRepository != null";
        assert (connectorId != null) : "connectorId != null";
        this._connectorId = connectorId;
        this._connectorRepository = connectorRepository;
        this._columnNameMapper = this._connectorRepository.getConnectorHint(connectorId, ColumnNameMapper.class).getValue();
    }

    protected String createColumnClause(List<ColumnMetaData> columns) throws SQLException {
        StringBuilder columnBuf = new StringBuilder();
        for (ColumnMetaData columnMetaData : columns) {
            columnBuf.append(this._columnNameMapper.mapColumnName(columnMetaData) + ", ");
        }
        columnBuf.setLength(columnBuf.length() - 2);
        return columnBuf.toString();
    }

    protected String createWhereClause(TableMetaData tableMetaData) throws SQLException {
        return "";
    }

    public List<ColumnMetaData> getMappedTargetColumns(TableMetaData sourceTableMetaData, TableMetaData targetTableMetaData, String sourceConnectorId) throws SQLException {
        List<ColumnMetaData> sourceColumns = ColumnOrderHint.getSortedColumns(this._connectorRepository, sourceConnectorId, sourceTableMetaData);
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        ColumnMapper columnMapper = this._connectorRepository.getConnectorHint(this._connectorId, ColumnMapper.class).getValue();
        for (ColumnMetaData sourceColumnMetaData : sourceColumns) {
            List<ColumnMetaData> columnMetaDataTarget = columnMapper.map(sourceColumnMetaData, targetTableMetaData);
            columns.addAll(columnMetaDataTarget);
        }
        return columns;
    }
}

