/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.statements;

import de.akquinet.jbosscc.guttenbase.configuration.TargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.exceptions.IncompatibleColumnsException;
import de.akquinet.jbosscc.guttenbase.exceptions.MissingDataException;
import de.akquinet.jbosscc.guttenbase.hints.ColumnOrderHint;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnMapper;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnTypeMapping;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.tools.CommonColumnTypeResolverTool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class InsertStatementFiller {
    private static final Logger LOG = Logger.getLogger(InsertStatementFiller.class);
    private final ConnectorRepository _connectorRepository;

    public InsertStatementFiller(ConnectorRepository connectorRepository) {
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
    }

    public void fillInsertStatementFromResultSet(String sourceConnectorId, TableMetaData sourceTableMetaData, String targetConnectorId, TableMetaData targetTableMetaData, TargetDatabaseConfiguration targetDatabaseConfiguration, Connection targetConnection, ResultSet rs, PreparedStatement insertStatement, int numberOfRowsPerBatch, boolean useMultipleValuesClauses) throws SQLException {
        CommonColumnTypeResolverTool commonColumnTypeResolver = new CommonColumnTypeResolverTool(this._connectorRepository);
        List<ColumnMetaData> sourceColumns = ColumnOrderHint.getSortedColumns(this._connectorRepository, sourceConnectorId, sourceTableMetaData);
        ColumnMapper columnMapper = this._connectorRepository.getConnectorHint(targetConnectorId, ColumnMapper.class).getValue();
        int currentIndex = 1;
        int dataItemsCount = 0;
        for (int currentRow = 0; currentRow < numberOfRowsPerBatch; ++currentRow) {
            boolean ok = rs.next();
            if (!ok) {
                throw new MissingDataException("No more data in row " + currentRow + "/" + numberOfRowsPerBatch);
            }
            targetDatabaseConfiguration.beforeNewRow(targetConnection, targetConnectorId, targetTableMetaData);
            for (int columnIndex = 1; columnIndex <= sourceColumns.size(); ++columnIndex) {
                ColumnMetaData columnMetaData1 = sourceColumns.get(columnIndex - 1);
                List<ColumnMetaData> columnMetaDataTarget = columnMapper.map(columnMetaData1, targetTableMetaData);
                if (columnMetaDataTarget.isEmpty()) continue;
                for (ColumnMetaData columnMetaData2 : columnMetaDataTarget) {
                    ColumnTypeMapping columnTypeMapping = this.findMapping(sourceConnectorId, targetConnectorId, commonColumnTypeResolver, columnMetaData1, columnMetaData2);
                    Object value = columnTypeMapping.getSourceColumnType().getValue(rs, columnIndex);
                    value = columnTypeMapping.getColumnDataMapper().map(columnMetaData1, columnMetaData2, value);
                    columnTypeMapping.getTargetColumnType().setValue(insertStatement, currentIndex++, value, columnMetaData2.getColumnType());
                    ++dataItemsCount;
                }
            }
            if (!useMultipleValuesClauses) {
                insertStatement.addBatch();
                currentIndex = 1;
            }
            targetDatabaseConfiguration.afterNewRow(targetConnection, targetConnectorId, targetTableMetaData);
        }
        if (useMultipleValuesClauses) {
            insertStatement.addBatch();
        }
        LOG.debug((Object)("Number of data items: " + dataItemsCount));
    }

    private ColumnTypeMapping findMapping(String sourceConnectorId, String targetConnectorId, CommonColumnTypeResolverTool commonColumnTypeResolver, ColumnMetaData columnMetaData1, ColumnMetaData columnMetaData2) throws SQLException, IncompatibleColumnsException {
        ColumnTypeMapping columnTypeMapping = commonColumnTypeResolver.getCommonColumnTypeMapping(sourceConnectorId, columnMetaData1, targetConnectorId, columnMetaData2);
        if (columnTypeMapping == null) {
            throw new IncompatibleColumnsException("Columns have incompatible types: " + columnMetaData1.getColumnName() + "/" + columnMetaData1.getColumnTypeName() + " vs. " + columnMetaData2.getColumnName() + "/" + columnMetaData2.getColumnTypeName());
        }
        return columnTypeMapping;
    }
}

