/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.statements;

import de.akquinet.jbosscc.guttenbase.connector.DatabaseType;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.statements.AbstractSelectStatementCreator;
import java.sql.SQLException;

public class SelectStatementCreator
extends AbstractSelectStatementCreator {
    public SelectStatementCreator(ConnectorRepository connectorRepository, String connectorId) {
        super(connectorRepository, connectorId);
    }

    @Override
    protected String createOrderBy(TableMetaData tableMetaData) throws SQLException {
        StringBuilder buf = new StringBuilder("ORDER BY ");
        int columnsAdded = 0;
        boolean isOracle = DatabaseType.ORACLE.equals((Object)tableMetaData.getDatabaseMetaData().getDatabaseType());
        int rangeFrom = isOracle ? 0 : -16;
        int rangeTo = 2000;
        for (int i = 0; i < tableMetaData.getColumnCount(); ++i) {
            ColumnMetaData columnMetaData = tableMetaData.getColumnMetaData().get(i);
            String columnName = this._columnNameMapper.mapColumnName(columnMetaData);
            int jdbcType = columnMetaData.getColumnType();
            if (jdbcType <= rangeFrom || jdbcType >= 2000) continue;
            buf.append(columnName + ", ");
            ++columnsAdded;
        }
        if (columnsAdded > 0) {
            buf.setLength(buf.length() - 2);
            return buf.toString();
        }
        return "";
    }
}

