/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.tools;

import de.akquinet.jbosscc.guttenbase.hints.TableOrderHint;
import de.akquinet.jbosscc.guttenbase.mapping.TableNameMapper;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.tools.EntityTableChecker;
import de.akquinet.jbosscc.guttenbase.tools.MinMaxIdSelectorTool;
import de.akquinet.jbosscc.guttenbase.tools.ScriptExecutorTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractSequenceUpdateTool {
    protected final ConnectorRepository _connectorRepository;
    protected final ScriptExecutorTool _scriptExecutor;
    protected final MinMaxIdSelectorTool _minMaxIdSelector;

    public AbstractSequenceUpdateTool(ConnectorRepository connectorRepository) {
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
        this._scriptExecutor = new ScriptExecutorTool(connectorRepository);
        this._minMaxIdSelector = new MinMaxIdSelectorTool(connectorRepository);
    }

    public void updateSequences(String connectorId) throws SQLException {
        List<TableMetaData> tableMetaDatas = TableOrderHint.getSortedTables(this._connectorRepository, connectorId);
        EntityTableChecker entityTableChecker = this._connectorRepository.getConnectorHint(connectorId, EntityTableChecker.class).getValue();
        TableNameMapper tableNameMapper = this._connectorRepository.getConnectorHint(connectorId, TableNameMapper.class).getValue();
        ArrayList<String> updateClauses = new ArrayList<String>();
        for (TableMetaData tableMetaData : tableMetaDatas) {
            if (!entityTableChecker.isEntityTable(tableMetaData)) continue;
            this._minMaxIdSelector.computeMinMax(connectorId, tableMetaData);
            long sequenceValue = this._minMaxIdSelector.getMaxValue() + 1L;
            String tableName = tableNameMapper.mapTableName(tableMetaData);
            String sequenceName = this.getSequenceName(tableName);
            updateClauses.add(this.getUpdateSequenceClause(sequenceName, sequenceValue));
        }
        this._scriptExecutor.executeScript(connectorId, false, false, updateClauses);
    }

    public abstract String getUpdateSequenceClause(String var1, long var2) throws SQLException;

    public abstract String getSequenceName(String var1) throws SQLException;
}

