/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.tools;

import de.akquinet.jbosscc.guttenbase.configuration.SourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.TargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.connector.Connector;
import de.akquinet.jbosscc.guttenbase.exceptions.TableConfigurationException;
import de.akquinet.jbosscc.guttenbase.hints.TableOrderHint;
import de.akquinet.jbosscc.guttenbase.mapping.TableMapper;
import de.akquinet.jbosscc.guttenbase.mapping.TableNameMapper;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.tools.MaxNumberOfDataItems;
import de.akquinet.jbosscc.guttenbase.tools.NumberOfRowsPerBatch;
import de.akquinet.jbosscc.guttenbase.utils.Util;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractTableCopyTool {
    protected static final Logger LOG = Logger.getLogger(AbstractTableCopyTool.class);
    protected final ConnectorRepository _connectorRepository;

    public AbstractTableCopyTool(ConnectorRepository connectorRepository) {
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
    }

    public void copyTables(String sourceConnectorId, String targetConnectorId) throws SQLException {
        List<TableMetaData> tableSourceMetaDatas = TableOrderHint.getSortedTables(this._connectorRepository, sourceConnectorId);
        NumberOfRowsPerBatch numberOfRowsPerInsertionHint = this._connectorRepository.getConnectorHint(targetConnectorId, NumberOfRowsPerBatch.class).getValue();
        MaxNumberOfDataItems maxNumberOfDataItemsHint = this._connectorRepository.getConnectorHint(targetConnectorId, MaxNumberOfDataItems.class).getValue();
        long start = System.currentTimeMillis();
        SourceDatabaseConfiguration sourceDatabaseConfiguration = this._connectorRepository.getSourceDatabaseConfiguration(sourceConnectorId);
        TargetDatabaseConfiguration targetDatabaseConfiguration = this._connectorRepository.getTargetDatabaseConfiguration(targetConnectorId);
        Connector sourceConnector = this._connectorRepository.createConnector(sourceConnectorId);
        Connector targetConnector = this._connectorRepository.createConnector(targetConnectorId);
        Connection sourceConnection = sourceConnector.openConnection();
        Connection targetConnection = targetConnector.openConnection();
        TableNameMapper sourceTableNameMapper = this._connectorRepository.getConnectorHint(sourceConnectorId, TableNameMapper.class).getValue();
        TableNameMapper targetTableNameMapper = this._connectorRepository.getConnectorHint(targetConnectorId, TableNameMapper.class).getValue();
        TableMapper tableMapper = this._connectorRepository.getConnectorHint(targetConnectorId, TableMapper.class).getValue();
        DatabaseMetaData targetDatabaseMetaData = this._connectorRepository.getDatabaseMetaData(targetConnectorId);
        sourceDatabaseConfiguration.initializeSourceConnection(sourceConnection, sourceConnectorId);
        targetDatabaseConfiguration.initializeTargetConnection(targetConnection, targetConnectorId);
        int tableCounter = 1;
        for (TableMetaData sourceTableMetaData : tableSourceMetaDatas) {
            TableMetaData targetTableMetaData = tableMapper.map(sourceTableMetaData, targetDatabaseMetaData);
            int defaultNumberOfRowsPerBatch = numberOfRowsPerInsertionHint.getNumberOfRowsPerBatch(targetTableMetaData);
            boolean useMultipleValuesClauses = numberOfRowsPerInsertionHint.useMultipleValuesClauses(targetTableMetaData);
            int maxNumberOfDataItems = maxNumberOfDataItemsHint.getMaxNumberOfDataItems(targetTableMetaData);
            if (targetTableMetaData == null) {
                throw new TableConfigurationException("No matching table for " + sourceTableMetaData + " in target data base!!!");
            }
            String sourceTableName = sourceTableNameMapper.mapTableName(sourceTableMetaData);
            String targetTableName = targetTableNameMapper.mapTableName(targetTableMetaData);
            long startTimeCopyTable = System.currentTimeMillis();
            int targetRowCount = targetTableMetaData.getRowCount();
            if (targetRowCount > 0) {
                LOG.warn((Object)("Target table " + targetTableMetaData.getTableName() + " is not empty!"));
            }
            int numberOfRowsPerBatch = defaultNumberOfRowsPerBatch;
            int columnCount = targetTableMetaData.getColumnCount();
            if (columnCount * numberOfRowsPerBatch > maxNumberOfDataItems) {
                numberOfRowsPerBatch = maxNumberOfDataItems / columnCount;
                LOG.debug((Object)("Max number of data items " + maxNumberOfDataItems + "exceeds numberOfValuesClauses * columns=" + defaultNumberOfRowsPerBatch + " * " + columnCount + ". Cutting down number of VALUES clauses to " + numberOfRowsPerBatch));
            }
            sourceDatabaseConfiguration.beforeTableCopy(sourceConnection, sourceConnectorId, sourceTableMetaData);
            targetDatabaseConfiguration.beforeTableCopy(targetConnection, targetConnectorId, targetTableMetaData);
            LOG.info((Object)("Copying of " + sourceTableName + "-> " + targetTableName + "(" + tableCounter + "/" + tableSourceMetaDatas.size() + ") started"));
            this.copyTable(sourceConnectorId, sourceConnection, sourceDatabaseConfiguration, sourceTableMetaData, sourceTableName, targetConnectorId, targetConnection, targetDatabaseConfiguration, targetTableMetaData, targetTableName, numberOfRowsPerBatch, useMultipleValuesClauses);
            LOG.info((Object)("Copying of " + sourceTableName + "-> " + targetTableName + "(" + tableCounter + "/" + tableSourceMetaDatas.size() + ") finished"));
            sourceDatabaseConfiguration.afterTableCopy(sourceConnection, sourceConnectorId, sourceTableMetaData);
            targetDatabaseConfiguration.afterTableCopy(targetConnection, targetConnectorId, targetTableMetaData);
            long endTimeCopyTable = System.currentTimeMillis();
            long elapsedTime = endTimeCopyTable - startTimeCopyTable;
            long averagePerLine = elapsedTime / (long)numberOfRowsPerBatch;
            LOG.info((Object)("Copying of " + sourceTableMetaData.getTableName() + " took " + Util.formatTime(elapsedTime)));
            LOG.info((Object)(sourceTableMetaData.getRowCount() + " lines copied, average per batch (" + numberOfRowsPerBatch + ") = " + Util.formatTime(averagePerLine)));
            ++tableCounter;
        }
        sourceDatabaseConfiguration.finalizeSourceConnection(sourceConnection, sourceConnectorId);
        targetDatabaseConfiguration.finalizeTargetConnection(targetConnection, targetConnectorId);
        sourceConnector.closeConnection();
        targetConnector.closeConnection();
        long end = System.currentTimeMillis();
        LOG.info((Object)("Copying took " + Util.formatTime(end - start) + " total"));
        this._connectorRepository.refreshDatabaseMetaData(targetConnectorId);
    }

    protected abstract void copyTable(String var1, Connection var2, SourceDatabaseConfiguration var3, TableMetaData var4, String var5, String var6, Connection var7, TargetDatabaseConfiguration var8, TableMetaData var9, String var10, int var11, boolean var12) throws SQLException;
}

