/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.tools;

import de.akquinet.jbosscc.guttenbase.hints.TableOrderHint;
import de.akquinet.jbosscc.guttenbase.mapping.TableNameMapper;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.tools.ScriptExecutorTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTablesOperationTool {
    public static final String TABLE_PLACEHOLDER = "@TABLE@";
    protected final ConnectorRepository _connectorRepository;
    protected final ScriptExecutorTool _scriptExecutor;
    private final String _template;

    public AbstractTablesOperationTool(ConnectorRepository connectorRepository, String template) {
        assert (connectorRepository != null) : "connectorRepository != null";
        assert (template != null) : "template != null";
        this._connectorRepository = connectorRepository;
        this._template = template;
        this._scriptExecutor = new ScriptExecutorTool(connectorRepository);
    }

    public void executeOnAllTables(String connectorId, boolean updateSchema, boolean prepareTargetConnection) throws SQLException {
        TableNameMapper tableNameMapper = this._connectorRepository.getConnectorHint(connectorId, TableNameMapper.class).getValue();
        List<TableMetaData> tables = TableOrderHint.getSortedTables(this._connectorRepository, connectorId);
        ArrayList<String> sql = new ArrayList<String>();
        for (TableMetaData tableMetaData : tables) {
            String tableName = tableNameMapper.mapTableName(tableMetaData);
            sql.add(this._template.replaceAll(TABLE_PLACEHOLDER, tableName));
        }
        this._scriptExecutor.executeScript(connectorId, updateSchema, prepareTargetConnection, sql);
    }

    public void executeOnTable(String connectorId, boolean updatesSchema, boolean prepareTargetConnection, TableMetaData tableMetaData) throws SQLException {
        TableNameMapper tableNameMapper = this._connectorRepository.getConnectorHint(connectorId, TableNameMapper.class).getValue();
        String tableName = tableNameMapper.mapTableName(tableMetaData);
        this._scriptExecutor.executeScript(connectorId, updatesSchema, prepareTargetConnection, this._template.replaceAll(TABLE_PLACEHOLDER, tableName));
    }
}

