/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.tools;

import de.akquinet.jbosscc.guttenbase.configuration.SourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.connector.Connector;
import de.akquinet.jbosscc.guttenbase.connector.ConnectorInfo;
import de.akquinet.jbosscc.guttenbase.connector.DatabaseType;
import de.akquinet.jbosscc.guttenbase.exceptions.IncompatibleColumnsException;
import de.akquinet.jbosscc.guttenbase.exceptions.TableConfigurationException;
import de.akquinet.jbosscc.guttenbase.exceptions.UnequalDataException;
import de.akquinet.jbosscc.guttenbase.exceptions.UnequalNumberOfRowsException;
import de.akquinet.jbosscc.guttenbase.hints.ColumnOrderHint;
import de.akquinet.jbosscc.guttenbase.hints.TableOrderHint;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnMapper;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnNameMapper;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnTypeMapping;
import de.akquinet.jbosscc.guttenbase.mapping.TableMapper;
import de.akquinet.jbosscc.guttenbase.mapping.TableNameMapper;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.ColumnType;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.statements.SelectStatementCreator;
import de.akquinet.jbosscc.guttenbase.tools.CommonColumnTypeResolverTool;
import de.akquinet.jbosscc.guttenbase.tools.NumberOfCheckedTableData;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;

public class CheckEqualTableDataTool {
    private static final Logger LOG = Logger.getLogger(CheckEqualTableDataTool.class);
    private final ConnectorRepository _connectorRepository;

    public CheckEqualTableDataTool(ConnectorRepository connectorRepository) {
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
    }

    public void checkTableData(String sourceConnectorId, String targetConnectorId) throws SQLException {
        List<TableMetaData> tableSourceMetaDatas = TableOrderHint.getSortedTables(this._connectorRepository, sourceConnectorId);
        int numberOfCheckData = this._connectorRepository.getConnectorHint(sourceConnectorId, NumberOfCheckedTableData.class).getValue().getNumberOfCheckedTableData();
        TableMapper tableMapper = this._connectorRepository.getConnectorHint(targetConnectorId, TableMapper.class).getValue();
        DatabaseMetaData targetDatabaseMetaData = this._connectorRepository.getDatabaseMetaData(targetConnectorId);
        SourceDatabaseConfiguration sourceDatabaseConfiguration1 = this._connectorRepository.getSourceDatabaseConfiguration(sourceConnectorId);
        SourceDatabaseConfiguration sourceDatabaseConfiguration2 = this._connectorRepository.getSourceDatabaseConfiguration(targetConnectorId);
        Connector connector1 = this._connectorRepository.createConnector(sourceConnectorId);
        Connector connector2 = this._connectorRepository.createConnector(targetConnectorId);
        Connection connection1 = connector1.openConnection();
        Connection connection2 = connector2.openConnection();
        sourceDatabaseConfiguration1.initializeSourceConnection(connection1, sourceConnectorId);
        sourceDatabaseConfiguration2.initializeSourceConnection(connection2, targetConnectorId);
        for (TableMetaData tableSourceMetaData : tableSourceMetaDatas) {
            TableMetaData tableDestMetaData = tableMapper.map(tableSourceMetaData, targetDatabaseMetaData);
            if (tableDestMetaData == null) {
                throw new TableConfigurationException("No matching table for " + tableSourceMetaData + " in target data base!!!");
            }
            this.checkTableData(sourceConnectorId, connection1, sourceDatabaseConfiguration1, tableSourceMetaData, targetConnectorId, connection2, sourceDatabaseConfiguration2, tableDestMetaData, numberOfCheckData);
        }
        sourceDatabaseConfiguration1.finalizeSourceConnection(connection1, sourceConnectorId);
        sourceDatabaseConfiguration2.finalizeSourceConnection(connection2, targetConnectorId);
        connector1.closeConnection();
        connector2.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTableData(String sourceConnectorId, Connection sourceConnection, SourceDatabaseConfiguration sourceConfiguration, TableMetaData sourceTableMetaData, String targetConnectorId, Connection targetConnection, SourceDatabaseConfiguration targetConfiguration, TableMetaData targetTableMetaData, int numberOfCheckData) throws SQLException {
        String tableName1 = this._connectorRepository.getConnectorHint(sourceConnectorId, TableNameMapper.class).getValue().mapTableName(sourceTableMetaData);
        String tableName2 = this._connectorRepository.getConnectorHint(targetConnectorId, TableNameMapper.class).getValue().mapTableName(targetTableMetaData);
        CommonColumnTypeResolverTool commonColumnTypeResolver = new CommonColumnTypeResolverTool(this._connectorRepository);
        ColumnNameMapper sourceColumnNameMapper = this._connectorRepository.getConnectorHint(sourceConnectorId, ColumnNameMapper.class).getValue();
        ColumnNameMapper targetColumnNameMapper = this._connectorRepository.getConnectorHint(targetConnectorId, ColumnNameMapper.class).getValue();
        if (sourceTableMetaData.getRowCount() != targetTableMetaData.getRowCount()) {
            throw new UnequalNumberOfRowsException("Number of rows is not equal: " + tableName1 + "=" + sourceTableMetaData.getRowCount() + " vs. " + tableName2 + "=" + targetTableMetaData.getRowCount());
        }
        LOG.info((Object)("Checking data of " + tableName1 + " <--> " + tableName2 + " started"));
        PreparedStatement selectStatement1 = new SelectStatementCreator(this._connectorRepository, sourceConnectorId).createSelectStatement(tableName1, sourceTableMetaData, sourceConnection);
        selectStatement1.setFetchSize(numberOfCheckData);
        sourceConfiguration.beforeSelect(sourceConnection, sourceConnectorId, sourceTableMetaData);
        ResultSet resultSet1 = selectStatement1.executeQuery();
        sourceConfiguration.afterSelect(sourceConnection, sourceConnectorId, sourceTableMetaData);
        PreparedStatement selectStatement2 = new SelectStatementCreator(this._connectorRepository, targetConnectorId).createMappedSelectStatement(sourceTableMetaData, tableName2, targetTableMetaData, targetConnection, sourceConnectorId);
        selectStatement2.setFetchSize(numberOfCheckData);
        targetConfiguration.beforeSelect(targetConnection, targetConnectorId, targetTableMetaData);
        ResultSet resultSet2 = selectStatement2.executeQuery();
        targetConfiguration.afterSelect(targetConnection, targetConnectorId, targetTableMetaData);
        List<ColumnMetaData> orderedSourceColumns = ColumnOrderHint.getSortedColumns(this._connectorRepository, sourceConnectorId, sourceTableMetaData);
        ColumnMapper columnMapper = this._connectorRepository.getConnectorHint(targetConnectorId, ColumnMapper.class).getValue();
        try {
            for (int rowIndex = 1; resultSet1.next() && resultSet2.next() && rowIndex <= numberOfCheckData; ++rowIndex) {
                for (int columnIndex = 1; columnIndex <= orderedSourceColumns.size(); ++columnIndex) {
                    ColumnMetaData sourceColumn = orderedSourceColumns.get(columnIndex - 1);
                    List<ColumnMetaData> targetColumns = columnMapper.map(sourceColumn, targetTableMetaData);
                    for (ColumnMetaData columnMetaData2 : targetColumns) {
                        ColumnTypeMapping columnTypeMapping = commonColumnTypeResolver.getCommonColumnTypeMapping(sourceConnectorId, sourceColumn, targetConnectorId, columnMetaData2);
                        String columnName1 = sourceColumnNameMapper.mapColumnName(sourceColumn);
                        String columnName2 = targetColumnNameMapper.mapColumnName(columnMetaData2);
                        if (columnTypeMapping == null) {
                            throw new IncompatibleColumnsException(tableName1 + ": Columns have incompatible types: " + columnName1 + "/" + sourceColumn.getColumnTypeName() + " vs. " + columnName2 + "/" + columnMetaData2.getColumnTypeName());
                        }
                        ColumnType sourceColumnType = columnTypeMapping.getSourceColumnType();
                        Object data1 = sourceColumnType.getValue(resultSet1, columnIndex);
                        data1 = columnTypeMapping.getColumnDataMapper().map(sourceColumn, columnMetaData2, data1);
                        Object data2 = columnTypeMapping.getTargetColumnType().getValue(resultSet2, columnIndex);
                        switch (sourceColumnType) {
                            case CLASS_STRING: {
                                ConnectorInfo connectionInfo1 = this._connectorRepository.getConnectionInfo(sourceConnectorId);
                                ConnectorInfo connectionInfo2 = this._connectorRepository.getConnectionInfo(targetConnectorId);
                                if (!DatabaseType.POSTGRESQL.equals((Object)connectionInfo1.getDatabaseType()) && !DatabaseType.POSTGRESQL.equals((Object)connectionInfo2.getDatabaseType())) break;
                                data1 = CheckEqualTableDataTool.trim((String)data1);
                                data2 = CheckEqualTableDataTool.trim((String)data2);
                                break;
                            }
                            case CLASS_BLOB: {
                                Blob blob1 = (Blob)data1;
                                Blob blob2 = (Blob)data2;
                                data1 = CheckEqualTableDataTool.createStringFromBlob(blob1);
                                data2 = CheckEqualTableDataTool.createStringFromBlob(blob2);
                            }
                        }
                        if (data1 == null && data2 != null || data1 != null && data2 == null) {
                            throw CheckEqualTableDataTool.createIncompatibleDataException(tableName1, rowIndex, sourceColumnType, columnName1, data1, data2);
                        }
                        if (data1 == null || data2 == null || data1.equals(data2)) continue;
                        throw CheckEqualTableDataTool.createIncompatibleDataException(tableName1, rowIndex, sourceColumnType, columnName1, data1, data2);
                    }
                }
            }
        }
        finally {
            try {
                resultSet1.close();
                selectStatement1.close();
                resultSet2.close();
                selectStatement2.close();
            }
            catch (Exception e) {}
        }
        LOG.info((Object)("Checking data of " + tableName1 + " <--> " + tableName2 + " finished"));
    }

    private static String createStringFromBlob(Blob blob) throws SQLException {
        return blob == null ? null : new String(blob.getBytes(1L, (int)Math.min(blob.length(), 1000L)));
    }

    private static String trim(String data) {
        return data == null ? null : data.trim();
    }

    private static SQLException createIncompatibleDataException(String tableName, int index, ColumnType columnType, String columnName, Object data1, Object data2) {
        return new UnequalDataException(tableName + ": Row " + index + ": Data not equal on column " + columnName + ": \n'" + data1 + "'\n vs. \n'" + data2 + "'\n, column class = " + columnType.getColumnClasses());
    }
}

