/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.tools;

import de.akquinet.jbosscc.guttenbase.exceptions.IncompatibleColumnsException;
import de.akquinet.jbosscc.guttenbase.exceptions.IncompatibleTablesException;
import de.akquinet.jbosscc.guttenbase.hints.ColumnOrderHint;
import de.akquinet.jbosscc.guttenbase.hints.TableOrderHint;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnMapper;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnNameMapper;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnTypeMapping;
import de.akquinet.jbosscc.guttenbase.mapping.TableMapper;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.tools.CommonColumnTypeResolverTool;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CheckSchemaCompatibilityTool {
    private final ConnectorRepository _connectorRepository;

    public CheckSchemaCompatibilityTool(ConnectorRepository connectorRepository) {
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
    }

    public void checkTableConfiguration(String sourceConnectorId, String targetConnectorId) throws SQLException {
        List<TableMetaData> sourceTableMetaData = TableOrderHint.getSortedTables(this._connectorRepository, sourceConnectorId);
        TableMapper tableMapper = this._connectorRepository.getConnectorHint(targetConnectorId, TableMapper.class).getValue();
        DatabaseMetaData targetDatabaseMetaData = this._connectorRepository.getDatabaseMetaData(targetConnectorId);
        this.checkEqualTables(sourceTableMetaData, targetDatabaseMetaData, tableMapper);
        for (TableMetaData tableMetaData1 : sourceTableMetaData) {
            TableMetaData tableMetaData2 = tableMapper.map(tableMetaData1, targetDatabaseMetaData);
            this.checkEqualColumns(sourceConnectorId, targetConnectorId, tableMetaData1, tableMetaData2);
        }
    }

    public void checkEqualColumns(String sourceConnectorId, String targetConnectorId, TableMetaData tableMetaData1, TableMetaData tableMetaData2) throws SQLException, IncompatibleColumnsException {
        ColumnMapper columnMapper = this._connectorRepository.getConnectorHint(targetConnectorId, ColumnMapper.class).getValue();
        CommonColumnTypeResolverTool commonColumnTypeResolver = new CommonColumnTypeResolverTool(this._connectorRepository);
        ColumnNameMapper sourceColumnNameMapper = this._connectorRepository.getConnectorHint(sourceConnectorId, ColumnNameMapper.class).getValue();
        ColumnNameMapper targetColumnNameMapper = this._connectorRepository.getConnectorHint(targetConnectorId, ColumnNameMapper.class).getValue();
        String tableName = tableMetaData1.getTableName();
        List<ColumnMetaData> sourceColumns = ColumnOrderHint.getSortedColumns(this._connectorRepository, sourceConnectorId, tableMetaData1);
        for (ColumnMetaData columnMetaData1 : sourceColumns) {
            List<ColumnMetaData> columnMetaDataTarget = columnMapper.map(columnMetaData1, tableMetaData2);
            String columnName1 = sourceColumnNameMapper.mapColumnName(columnMetaData1);
            if (columnMetaDataTarget.isEmpty()) {
                throw new IncompatibleColumnsException("No mapping column(s) found for: " + columnMetaData1);
            }
            for (ColumnMetaData columnMetaData2 : columnMetaDataTarget) {
                String columnName2 = targetColumnNameMapper.mapColumnName(columnMetaData2);
                ColumnTypeMapping columnTypeMapping = commonColumnTypeResolver.getCommonColumnTypeMapping(sourceConnectorId, columnMetaData1, targetConnectorId, columnMetaData2);
                if (columnTypeMapping != null) continue;
                throw new IncompatibleColumnsException(tableName + ":" + columnMetaData1 + ": Columns have incompatible types: " + columnName1 + "/" + columnMetaData1.getColumnTypeName() + "/" + columnMetaData1.getColumnClassName() + " vs. " + columnName2 + "/" + columnMetaData2.getColumnTypeName() + "/" + columnMetaData2.getColumnClassName());
            }
        }
    }

    private void checkEqualTables(List<TableMetaData> sourceTableMetaData, DatabaseMetaData targetDatabaseMetaData, TableMapper tableMapper) throws SQLException {
        ArrayList<TableMetaData> missingData = new ArrayList<TableMetaData>();
        for (TableMetaData tableMetaData : sourceTableMetaData) {
            TableMetaData targetTableMetaData = tableMapper.map(tableMetaData, targetDatabaseMetaData);
            if (targetTableMetaData != null) continue;
            missingData.add(tableMetaData);
        }
        if (!missingData.isEmpty()) {
            throw new IncompatibleTablesException("Tables mismatch: Unknown/Unmapped source tables \n" + missingData);
        }
    }
}

