/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.tools;

import de.akquinet.jbosscc.guttenbase.hints.impl.DefaultColumnDataMapper;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnDataMapper;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnDataMapperProvider;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnTypeMapping;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnTypeResolver;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnTypeResolverList;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.ColumnType;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import java.sql.SQLException;
import java.util.List;

public class CommonColumnTypeResolverTool {
    private final ConnectorRepository _connectorRepository;

    public CommonColumnTypeResolverTool(ConnectorRepository connectorRepository) {
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
    }

    public ColumnTypeMapping getCommonColumnTypeMapping(String sourceConnectorId, ColumnMetaData sourceColumnMetaData, String targetConnectorId, ColumnMetaData targetColumnMetaData) throws SQLException {
        List<ColumnTypeResolver> columnTypeResolvers = this._connectorRepository.getConnectorHint(targetConnectorId, ColumnTypeResolverList.class).getValue().getColumnTypeResolvers();
        for (ColumnTypeResolver columnTypeResolver : columnTypeResolvers) {
            ColumnTypeMapping result = this.findMapping(columnTypeResolver, sourceColumnMetaData, targetColumnMetaData, targetConnectorId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public ColumnType getColumnType(String connectorId, ColumnMetaData columnMetaData) throws SQLException {
        List<ColumnTypeResolver> columnTypeResolvers = this._connectorRepository.getConnectorHint(connectorId, ColumnTypeResolverList.class).getValue().getColumnTypeResolvers();
        for (ColumnTypeResolver columnTypeResolver : columnTypeResolvers) {
            ColumnType columnType = columnTypeResolver.getColumnType(columnMetaData);
            if (ColumnType.CLASS_UNKNOWN.equals((Object)columnType)) continue;
            return columnType;
        }
        return ColumnType.CLASS_UNKNOWN;
    }

    private ColumnTypeMapping findMapping(ColumnTypeResolver columnTypeResolver, ColumnMetaData sourceColumnMetaData, ColumnMetaData targetColumnMetaData, String targetConnectorId) throws SQLException {
        ColumnType sourceColumnType = columnTypeResolver.getColumnType(sourceColumnMetaData);
        ColumnType targetColumnType = columnTypeResolver.getColumnType(targetColumnMetaData);
        if (!ColumnType.CLASS_UNKNOWN.equals((Object)sourceColumnType) && !ColumnType.CLASS_UNKNOWN.equals((Object)targetColumnType)) {
            ColumnDataMapperProvider columnDataMapperFactory = this._connectorRepository.getConnectorHint(targetConnectorId, ColumnDataMapperProvider.class).getValue();
            ColumnDataMapper columnDataMapper = columnDataMapperFactory.findMapping(sourceColumnMetaData, targetColumnMetaData, sourceColumnType, targetColumnType);
            if (columnDataMapper != null) {
                return new ColumnTypeMapping(sourceColumnType, targetColumnType, columnDataMapper);
            }
            if (sourceColumnType.equals((Object)targetColumnType)) {
                return new ColumnTypeMapping(sourceColumnType, targetColumnType, new DefaultColumnDataMapper());
            }
        }
        return null;
    }
}

