/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.tools;

import de.akquinet.jbosscc.guttenbase.configuration.SourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.TargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.statements.InsertStatementCreator;
import de.akquinet.jbosscc.guttenbase.statements.InsertStatementFiller;
import de.akquinet.jbosscc.guttenbase.statements.SelectStatementCreator;
import de.akquinet.jbosscc.guttenbase.tools.AbstractTableCopyTool;
import de.akquinet.jbosscc.guttenbase.utils.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DefaultTableCopyTool
extends AbstractTableCopyTool {
    public DefaultTableCopyTool(ConnectorRepository connectorRepository) {
        super(connectorRepository);
    }

    @Override
    protected void copyTable(String sourceConnectorId, Connection sourceConnection, SourceDatabaseConfiguration sourceDatabaseConfiguration, TableMetaData sourceTableMetaData, String sourceTableName, String targetConnectorId, Connection targetConnection, TargetDatabaseConfiguration targetDatabaseConfiguration, TableMetaData targetTableMetaData, String targetTableName, int numberOfRowsPerBatch, boolean useMultipleValuesClauses) throws SQLException {
        int sourceRowCount = sourceTableMetaData.getRowCount();
        PreparedStatement selectStatement = new SelectStatementCreator(this._connectorRepository, sourceConnectorId).createSelectStatement(sourceTableName, sourceTableMetaData, sourceConnection);
        selectStatement.setFetchSize(Math.min(numberOfRowsPerBatch, selectStatement.getMaxRows()));
        sourceDatabaseConfiguration.beforeSelect(sourceConnection, sourceConnectorId, sourceTableMetaData);
        ResultSet resultSet = selectStatement.executeQuery();
        sourceDatabaseConfiguration.afterSelect(sourceConnection, sourceConnectorId, sourceTableMetaData);
        int bulkUpdateCount = sourceRowCount / numberOfRowsPerBatch;
        int remainder = sourceRowCount - bulkUpdateCount * numberOfRowsPerBatch;
        InsertStatementCreator insertStatementCreator = new InsertStatementCreator(this._connectorRepository, targetConnectorId);
        InsertStatementFiller insertStatementFiller = new InsertStatementFiller(this._connectorRepository);
        targetDatabaseConfiguration.beforeInsert(targetConnection, targetConnectorId, targetTableMetaData);
        PreparedStatement bulkInsert = insertStatementCreator.createInsertStatement(sourceConnectorId, sourceTableMetaData, targetTableName, targetTableMetaData, targetConnection, numberOfRowsPerBatch, useMultipleValuesClauses);
        LOG.debug((Object)("Table row count = " + sourceRowCount + ", numberOfRowsPerBatch = " + numberOfRowsPerBatch + ", bulkUpdateCount = " + bulkUpdateCount));
        for (int i = 0; i < bulkUpdateCount; ++i) {
            long startBatchTime = System.currentTimeMillis();
            insertStatementFiller.fillInsertStatementFromResultSet(sourceConnectorId, sourceTableMetaData, targetConnectorId, targetTableMetaData, targetDatabaseConfiguration, targetConnection, resultSet, bulkInsert, numberOfRowsPerBatch, useMultipleValuesClauses);
            bulkInsert.executeBatch();
            targetConnection.commit();
            long endBatchTime = System.currentTimeMillis();
            LOG.info((Object)(sourceTableName + ": " + (i + 1) * numberOfRowsPerBatch + "/" + sourceRowCount + " rows copied: last batch update took " + Util.formatTime(endBatchTime - startBatchTime)));
        }
        if (bulkUpdateCount > 0) {
            bulkInsert.close();
        }
        if (remainder > 0) {
            PreparedStatement finalInsert = insertStatementCreator.createInsertStatement(sourceConnectorId, sourceTableMetaData, targetTableName, targetTableMetaData, targetConnection, remainder, useMultipleValuesClauses);
            insertStatementFiller.fillInsertStatementFromResultSet(sourceConnectorId, sourceTableMetaData, targetConnectorId, targetTableMetaData, targetDatabaseConfiguration, targetConnection, resultSet, finalInsert, remainder, useMultipleValuesClauses);
            finalInsert.executeBatch();
            targetConnection.commit();
            finalInsert.close();
        }
        targetDatabaseConfiguration.afterInsert(targetConnection, targetConnectorId, targetTableMetaData);
        if (resultSet.next()) {
            LOG.warn((Object)"Uncopied data!!!");
        }
        resultSet.close();
        selectStatement.close();
    }
}

