/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.tools;

import de.akquinet.jbosscc.guttenbase.connector.Connector;
import de.akquinet.jbosscc.guttenbase.mapping.TableNameMapper;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.statements.SplitByColumnSelectMinMaxStatementCreator;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MinMaxIdSelectorTool {
    private final ConnectorRepository _connectorRepository;
    private long _minValue;
    private long _maxValue;

    public MinMaxIdSelectorTool(ConnectorRepository connectorRepository) {
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
    }

    public void computeMinMax(String connectorId, TableMetaData tableMetaData) throws SQLException {
        Connector connector = this._connectorRepository.createConnector(connectorId);
        Connection connection = connector.openConnection();
        this.computeMinMax(connectorId, tableMetaData, connection);
        connector.closeConnection();
    }

    public void computeMinMax(String connectorId, TableMetaData tableMetaData, Connection connection) throws SQLException {
        TableNameMapper tableNameMapper = this._connectorRepository.getConnectorHint(connectorId, TableNameMapper.class).getValue();
        String tableName = tableNameMapper.mapTableName(tableMetaData);
        PreparedStatement minMaxStatement = new SplitByColumnSelectMinMaxStatementCreator(this._connectorRepository, connectorId).createSelectStatement(tableName, tableMetaData, connection);
        ResultSet rangeResultSet = minMaxStatement.executeQuery();
        rangeResultSet.next();
        this._minValue = rangeResultSet.getLong(1);
        this._maxValue = rangeResultSet.getLong(2);
        minMaxStatement.close();
    }

    public long getMinValue() {
        return this._minValue;
    }

    public long getMaxValue() {
        return this._maxValue;
    }
}

