/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.tools;

import de.akquinet.jbosscc.guttenbase.configuration.SourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.connector.Connector;
import de.akquinet.jbosscc.guttenbase.hints.ColumnOrderHint;
import de.akquinet.jbosscc.guttenbase.mapping.ColumnNameMapper;
import de.akquinet.jbosscc.guttenbase.mapping.TableNameMapper;
import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.ColumnType;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.statements.SelectStatementCreator;
import de.akquinet.jbosscc.guttenbase.tools.CommonColumnTypeResolverTool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReadTableDataTool {
    private final ConnectorRepository _connectorRepository;

    public ReadTableDataTool(ConnectorRepository connectorRepository) {
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
    }

    public List<Map<String, Object>> readTableData(String connectorId, TableMetaData tableMetaData, int lines) throws SQLException {
        SourceDatabaseConfiguration sourceDatabaseConfiguration = this._connectorRepository.getSourceDatabaseConfiguration(connectorId);
        Connector connector = this._connectorRepository.createConnector(connectorId);
        Connection connection = connector.openConnection();
        sourceDatabaseConfiguration.initializeSourceConnection(connection, connectorId);
        List<Map<String, Object>> result = this.readTableData(connection, connectorId, sourceDatabaseConfiguration, tableMetaData, lines < 0 ? Integer.MAX_VALUE : lines);
        sourceDatabaseConfiguration.finalizeSourceConnection(connection, connectorId);
        connector.closeConnection();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> readTableData(Connection connection, String connectorId, SourceDatabaseConfiguration sourceConfiguration, TableMetaData tableMetaData, int lines) throws SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        String tableName = this._connectorRepository.getConnectorHint(connectorId, TableNameMapper.class).getValue().mapTableName(tableMetaData);
        CommonColumnTypeResolverTool commonColumnTypeResolver = new CommonColumnTypeResolverTool(this._connectorRepository);
        ColumnNameMapper sourceColumnNameMapper = this._connectorRepository.getConnectorHint(connectorId, ColumnNameMapper.class).getValue();
        PreparedStatement selectStatement = new SelectStatementCreator(this._connectorRepository, connectorId).createSelectStatement(tableName, tableMetaData, connection);
        selectStatement.setFetchSize(lines);
        sourceConfiguration.beforeSelect(connection, connectorId, tableMetaData);
        ResultSet resultSet = selectStatement.executeQuery();
        sourceConfiguration.afterSelect(connection, connectorId, tableMetaData);
        List<ColumnMetaData> orderedSourceColumns = ColumnOrderHint.getSortedColumns(this._connectorRepository, connectorId, tableMetaData);
        try {
            for (int rowIndex = 1; resultSet.next() && rowIndex <= lines; ++rowIndex) {
                HashMap<String, Object> rowData = new HashMap<String, Object>();
                for (int columnIndex = 1; columnIndex <= orderedSourceColumns.size(); ++columnIndex) {
                    ColumnMetaData sourceColumn = orderedSourceColumns.get(columnIndex - 1);
                    String columnName = sourceColumnNameMapper.mapColumnName(sourceColumn);
                    ColumnType sourceColumnType = commonColumnTypeResolver.getColumnType(connectorId, sourceColumn);
                    Object data = sourceColumnType.getValue(resultSet, columnIndex);
                    rowData.put(columnName, data);
                }
                result.add(rowData);
            }
        }
        finally {
            try {
                resultSet.close();
                selectStatement.close();
            }
            catch (Exception e) {}
        }
        return result;
    }
}

