/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.tools;

import de.akquinet.jbosscc.guttenbase.configuration.TargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.connector.Connector;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.sql.SQLLexer;
import de.akquinet.jbosscc.guttenbase.utils.Util;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ScriptExecutorTool {
    private static final Logger LOG = Logger.getLogger(ScriptExecutorTool.class);
    private final ConnectorRepository _connectorRepository;

    public ScriptExecutorTool(ConnectorRepository connectorRepository) {
        assert (connectorRepository != null) : "connectorRepository != null";
        this._connectorRepository = connectorRepository;
    }

    public void executeFileScript(String connectorId, String resourceName) throws SQLException {
        this.executeFileScript(connectorId, true, true, resourceName);
    }

    public void executeFileScript(String connectorId, boolean updateSchema, boolean prepareTargetConnection, String resourceName) throws SQLException {
        this.executeScript(connectorId, updateSchema, prepareTargetConnection, Util.readLinesFromFile(resourceName));
    }

    public void executeScript(String connectorId, String ... lines) throws SQLException {
        this.executeScript(connectorId, true, true, lines);
    }

    public void executeScript(String connectorId, boolean updateSchema, boolean prepareTargetConnection, String ... lines) throws SQLException {
        this.executeScript(connectorId, updateSchema, prepareTargetConnection, Arrays.asList(lines));
    }

    public void executeScript(String connectorId, List<String> lines) throws SQLException {
        this.executeScript(connectorId, true, true, lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeScript(String connectorId, boolean scriptUpdatesSchema, boolean prepareTargetConnection, List<String> lines) throws SQLException {
        if (lines.isEmpty()) {
            throw new SQLException("DDL script not found or empty");
        }
        List<String> sqlStatements = new SQLLexer(lines).parse();
        Connector connector = this._connectorRepository.createConnector(connectorId);
        Connection connection = connector.openConnection();
        if (prepareTargetConnection) {
            TargetDatabaseConfiguration targetDatabaseConfiguration = this._connectorRepository.getTargetDatabaseConfiguration(connectorId);
            targetDatabaseConfiguration.initializeTargetConnection(connection, connectorId);
        }
        Statement statement = connection.createStatement();
        try {
            for (String sql : sqlStatements) {
                this.executeSQL(statement, sql);
            }
            statement.close();
            if (prepareTargetConnection) {
                TargetDatabaseConfiguration targetDatabaseConfiguration = this._connectorRepository.getTargetDatabaseConfiguration(connectorId);
                targetDatabaseConfiguration.finalizeTargetConnection(connection, connectorId);
            }
        }
        finally {
            connector.closeConnection();
        }
        if (scriptUpdatesSchema) {
            this._connectorRepository.refreshDatabaseMetaData(connectorId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> executeQuery(String connectorId, String sql) throws SQLException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Connector connector = this._connectorRepository.createConnector(connectorId);
        try {
            Connection connection = connector.openConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            ResultSetMetaData metaData = resultSet.getMetaData();
            while (resultSet.next()) {
                int columnCount = metaData.getColumnCount();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = metaData.getColumnName(i);
                    Object value = resultSet.getObject(i);
                    map.put(columnName, value);
                }
                result.add(map);
            }
        }
        finally {
            connector.closeConnection();
        }
        return result;
    }

    private void executeSQL(Statement statement, String sql) throws SQLException {
        LOG.info((Object)("Executing: " + sql));
        statement.execute(sql);
    }
}

