/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.tools;

import de.akquinet.jbosscc.guttenbase.configuration.SourceDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.configuration.TargetDatabaseConfiguration;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import de.akquinet.jbosscc.guttenbase.repository.ConnectorRepository;
import de.akquinet.jbosscc.guttenbase.statements.InsertStatementCreator;
import de.akquinet.jbosscc.guttenbase.statements.InsertStatementFiller;
import de.akquinet.jbosscc.guttenbase.statements.SplitByColumnSelectCountStatementCreator;
import de.akquinet.jbosscc.guttenbase.statements.SplitByColumnSelectStatementCreator;
import de.akquinet.jbosscc.guttenbase.tools.AbstractTableCopyTool;
import de.akquinet.jbosscc.guttenbase.tools.MinMaxIdSelectorTool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class SplitByRangeTableCopyTool
extends AbstractTableCopyTool {
    public SplitByRangeTableCopyTool(ConnectorRepository connectorRepository) {
        super(connectorRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void copyTable(String sourceConnectorId, Connection sourceConnection, SourceDatabaseConfiguration sourceDatabaseConfiguration, TableMetaData sourceTableMetaData, String sourceTableName, String targetConnectorId, Connection targetConnection, TargetDatabaseConfiguration targetDatabaseConfiguration, TableMetaData targetTableMetaData, String targetTableName, int numberOfRowsPerBatch, boolean useMultipleValuesClauses) throws SQLException {
        int sourceRowCount = sourceTableMetaData.getRowCount();
        InsertStatementCreator insertStatementCreator = new InsertStatementCreator(this._connectorRepository, targetConnectorId);
        InsertStatementFiller insertStatementFiller = new InsertStatementFiller(this._connectorRepository);
        MinMaxIdSelectorTool minMaxIdSelector = new MinMaxIdSelectorTool(this._connectorRepository);
        minMaxIdSelector.computeMinMax(sourceConnectorId, sourceTableMetaData, sourceConnection);
        long minValue = minMaxIdSelector.getMinValue();
        long maxValue = minMaxIdSelector.getMaxValue();
        PreparedStatement countStatement = new SplitByColumnSelectCountStatementCreator(this._connectorRepository, sourceConnectorId).createSelectStatement(sourceTableName, sourceTableMetaData, sourceConnection);
        PreparedStatement selectStatement = new SplitByColumnSelectStatementCreator(this._connectorRepository, sourceConnectorId).createSelectStatement(sourceTableName, sourceTableMetaData, sourceConnection);
        selectStatement.setFetchSize(Math.min(numberOfRowsPerBatch, selectStatement.getMaxRows()));
        int totalWritten = 0;
        for (long splitColumnValue = minValue; splitColumnValue <= maxValue; splitColumnValue += (long)(numberOfRowsPerBatch + 1)) {
            long start = splitColumnValue;
            long end = splitColumnValue + (long)numberOfRowsPerBatch;
            sourceDatabaseConfiguration.beforeSelect(sourceConnection, sourceConnectorId, sourceTableMetaData);
            long countData = this.getCurrentCount(countStatement, start, end);
            sourceDatabaseConfiguration.afterSelect(sourceConnection, sourceConnectorId, sourceTableMetaData);
            if (countData <= 0L) continue;
            LOG.debug((Object)(sourceTableName + ": " + " from " + start + " to " + end + " yields " + countData + " rows"));
            selectStatement.setLong(1, start);
            selectStatement.setLong(2, end);
            sourceDatabaseConfiguration.beforeSelect(sourceConnection, sourceConnectorId, sourceTableMetaData);
            ResultSet resultSet = selectStatement.executeQuery();
            sourceDatabaseConfiguration.afterSelect(sourceConnection, sourceConnectorId, sourceTableMetaData);
            targetDatabaseConfiguration.beforeInsert(targetConnection, targetConnectorId, targetTableMetaData);
            PreparedStatement bulkInsert = insertStatementCreator.createInsertStatement(sourceConnectorId, sourceTableMetaData, targetTableName, targetTableMetaData, targetConnection, (int)countData, useMultipleValuesClauses);
            try {
                insertStatementFiller.fillInsertStatementFromResultSet(sourceConnectorId, sourceTableMetaData, targetConnectorId, targetTableMetaData, targetDatabaseConfiguration, targetConnection, resultSet, bulkInsert, (int)countData, useMultipleValuesClauses);
                bulkInsert.executeBatch();
                targetConnection.commit();
                totalWritten = (int)((long)totalWritten + countData);
                LOG.debug((Object)(countData + " written / " + totalWritten + " total written / " + sourceRowCount + " rows "));
                if (resultSet.next()) {
                    LOG.warn((Object)"Uncopied data!!!");
                }
            }
            catch (SQLException e) {
                LOG.error((Object)("Error while copying from " + start + " TO " + end), (Throwable)e);
            }
            finally {
                resultSet.close();
                bulkInsert.close();
            }
            targetDatabaseConfiguration.afterInsert(targetConnection, targetConnectorId, targetTableMetaData);
        }
        countStatement.close();
        selectStatement.close();
    }

    private long getCurrentCount(PreparedStatement countStatement, long start, long end) throws SQLException {
        countStatement.setLong(1, start);
        countStatement.setLong(2, end);
        ResultSet countQuery = countStatement.executeQuery();
        countQuery.next();
        return countQuery.getLong(1);
    }
}

