/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.guttenbase.utils;

import de.akquinet.jbosscc.guttenbase.meta.ColumnMetaData;
import de.akquinet.jbosscc.guttenbase.meta.DatabaseMetaData;
import de.akquinet.jbosscc.guttenbase.meta.IndexMetaData;
import de.akquinet.jbosscc.guttenbase.meta.TableMetaData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DatabaseSchemaScriptCreator {
    private int _foreignKeyCounter = 1;

    public List<String> createTableStatements(DatabaseMetaData databaseMetaData) {
        ArrayList<String> result = new ArrayList<String>();
        for (TableMetaData tableMetaData : databaseMetaData.getTableMetaData()) {
            result.add(this.createTable(tableMetaData));
        }
        return result;
    }

    public List<String> createIndexStatements(DatabaseMetaData databaseMetaData) {
        ArrayList<String> result = new ArrayList<String>();
        for (TableMetaData tableMetaData : databaseMetaData.getTableMetaData()) {
            List<IndexMetaData> indexes = tableMetaData.getIndexes();
            for (IndexMetaData indexMetaData : indexes) {
                result.add(this.createIndexesForTable(indexMetaData));
            }
        }
        return result;
    }

    public List<String> createForeignKeyStatements(DatabaseMetaData databaseMetaData) {
        ArrayList<String> result = new ArrayList<String>();
        for (TableMetaData tableMetaData : databaseMetaData.getTableMetaData()) {
            List<ColumnMetaData> columns = tableMetaData.getColumnMetaData();
            for (ColumnMetaData columnMetaData : columns) {
                if (columnMetaData.getReferencedColumn() == null) continue;
                result.add(this.createForeignKeyForTable(columnMetaData));
            }
        }
        return result;
    }

    private String createTable(TableMetaData tableMetaData) {
        String schema = tableMetaData.getDatabaseMetaData().getSchema().trim();
        StringBuilder builder = new StringBuilder("CREATE TABLE " + ("".equals(schema) ? "" : schema + ".") + tableMetaData.getTableName() + "\n(\n");
        Iterator<ColumnMetaData> iterator = tableMetaData.getColumnMetaData().iterator();
        while (iterator.hasNext()) {
            ColumnMetaData columnMetaData = iterator.next();
            builder.append("  " + this.createColumn(columnMetaData));
            if (!iterator.hasNext()) continue;
            builder.append(", \n");
        }
        builder.append("\n);");
        return builder.toString();
    }

    private String createIndexesForTable(IndexMetaData indexMetaData) {
        TableMetaData tableMetaData = indexMetaData.getTableMetaData();
        String schema = tableMetaData.getDatabaseMetaData().getSchema().trim();
        String schemaPrefix = "".equals(schema) ? "" : schema + ".";
        String unique = indexMetaData.isUnique() ? " UNIQUE " : " ";
        StringBuilder builder = new StringBuilder("CREATE" + unique + "INDEX " + indexMetaData.getIndexName() + " ON " + schemaPrefix + tableMetaData.getTableName() + "(");
        Iterator<ColumnMetaData> iterator = indexMetaData.getColumnMetaData().iterator();
        while (iterator.hasNext()) {
            ColumnMetaData columnMetaData = iterator.next();
            builder.append(columnMetaData.getColumnName());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(");");
        return builder.toString();
    }

    private String createForeignKeyForTable(ColumnMetaData columnMetaData) {
        TableMetaData tableMetaData = columnMetaData.getTableMetaData();
        String schema = tableMetaData.getDatabaseMetaData().getSchema().trim();
        String schemaPrefix = "".equals(schema) ? "" : schema + ".";
        ColumnMetaData referencedColumn = columnMetaData.getReferencedColumn();
        StringBuilder builder = new StringBuilder("ALTER TABLE " + schemaPrefix + tableMetaData.getTableName() + " ADD CONSTRAINT ");
        builder.append("FK_" + columnMetaData.getColumnName().toUpperCase() + "_" + referencedColumn.getColumnName().toUpperCase() + "_" + this._foreignKeyCounter++);
        builder.append(" FOREIGN KEY (" + columnMetaData.getColumnName() + ") + REFERENCES " + schemaPrefix + referencedColumn.getTableMetaData() + "(" + referencedColumn.getColumnName() + ")");
        return builder.toString();
    }

    private String createColumn(ColumnMetaData columnMetaData) {
        StringBuilder builder = new StringBuilder();
        builder.append(columnMetaData.getColumnName() + " " + columnMetaData.getColumnTypeName());
        if (columnMetaData.isPrimaryKey()) {
            builder.append(" PRIMARY KEY");
        } else if (!columnMetaData.isNullable()) {
            builder.append(" NOT NULL");
        }
        return builder.toString();
    }
}

